/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

import { has } from 'lodash/fp';
export var isKibanaError = function isKibanaError(error) {
  return has('message', error) && has('body.message', error) && has('body.statusCode', error);
};
export var isSecurityAppError = function isSecurityAppError(error) {
  return has('message', error) && has('body.message', error) && has('body.status_code', error);
};
export var isAppError = function isAppError(error) {
  return isKibanaError(error) || isSecurityAppError(error);
};
export var isNotFoundError = function isNotFoundError(error) {
  return isKibanaError(error) && error.body.statusCode === 404 || isSecurityAppError(error) && error.body.status_code === 404;
};