"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRequestId = getRequestId;
var _uuid = _interopRequireDefault(require("uuid"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getRequestId(request, {
  allowFromAnyIp,
  ipAllowlist
}) {
  var _request$raw$req$sock, _request$headers$xOp;
  const remoteAddress = (_request$raw$req$sock = request.raw.req.socket) === null || _request$raw$req$sock === void 0 ? void 0 : _request$raw$req$sock.remoteAddress;
  return allowFromAnyIp ||
  // socket may be undefined in integration tests that connect via the http listener directly
  remoteAddress && ipAllowlist.includes(remoteAddress) ? (_request$headers$xOp = request.headers['x-opaque-id']) !== null && _request$headers$xOp !== void 0 ? _request$headers$xOp : _uuid.default.v4() : _uuid.default.v4();
}