"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TsLib = exports.Theme = exports.StyledComponents = exports.SaferLodashSet = exports.RxjsOperators = exports.Rxjs = exports.RisonNode = exports.ReactRouterDom = exports.ReactRouter = exports.ReactDomServer = exports.ReactDom = exports.ReactBeautifulDnD = exports.React = exports.MonacoBarePluginApi = exports.MomentTimezone = exports.Moment = exports.LodashFp = exports.Lodash = exports.KbnStd = exports.KbnMonaco = exports.KbnI18nReact = exports.KbnI18n = exports.KbnAnalytics = exports.Jquery = exports.History = exports.Fflate = exports.EmotionReact = exports.ElasticNumeral = exports.ElasticEuiLibServicesFormat = exports.ElasticEuiLibServices = exports.ElasticEuiChartsTheme = exports.ElasticEui = exports.ElasticDatemath = exports.ElasticCharts = exports.Classnames = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

require('./polyfills');
const Jquery = exports.Jquery = require('jquery');
window.$ = window.jQuery = Jquery;
// mutates window.jQuery and window.$
require('./flot_charts');

// stateful deps
const KbnI18n = exports.KbnI18n = require('@kbn/i18n');
const KbnI18nReact = exports.KbnI18nReact = require('@kbn/i18n/react');
const EmotionReact = exports.EmotionReact = require('@emotion/react');
const Moment = exports.Moment = require('moment');
const MomentTimezone = exports.MomentTimezone = require('moment-timezone/moment-timezone');
const KbnMonaco = exports.KbnMonaco = require('@kbn/monaco');
const MonacoBarePluginApi = exports.MonacoBarePluginApi = require('@kbn/monaco').BarePluginApi;
const React = exports.React = require('react');
const ReactDom = exports.ReactDom = require('react-dom');
const ReactDomServer = exports.ReactDomServer = require('react-dom/server');
// eslint-disable-next-line @kbn/eslint/module_migration
const ReactRouter = exports.ReactRouter = require('react-router');
const ReactRouterDom = exports.ReactRouterDom = require('react-router-dom');
const StyledComponents = exports.StyledComponents = require('styled-components');
Moment.tz.load(require('moment-timezone/data/packed/latest.json'));

// big deps which are locked to a single version
const Rxjs = exports.Rxjs = require('rxjs');
const RxjsOperators = exports.RxjsOperators = require('rxjs/operators');
const ElasticNumeral = exports.ElasticNumeral = require('@elastic/numeral');
const ElasticCharts = exports.ElasticCharts = require('@elastic/charts');
const ElasticEui = exports.ElasticEui = require('@elastic/eui');
const ElasticEuiLibServices = exports.ElasticEuiLibServices = require('@elastic/eui/lib/services');
const ElasticEuiLibServicesFormat = exports.ElasticEuiLibServicesFormat = require('@elastic/eui/lib/services/format');
const ElasticEuiChartsTheme = exports.ElasticEuiChartsTheme = require('@elastic/eui/dist/eui_charts_theme');
const ElasticDatemath = exports.ElasticDatemath = require('@elastic/datemath');
const ReactBeautifulDnD = exports.ReactBeautifulDnD = require('react-beautiful-dnd');
const Theme = exports.Theme = require('./theme.ts');
const Lodash = exports.Lodash = require('lodash');
const LodashFp = exports.LodashFp = require('lodash/fp');
const {
  unzlibSync,
  strFromU8
} = require('fflate');
const Fflate = exports.Fflate = {
  unzlibSync,
  strFromU8
};

// runtime deps which don't need to be copied across all bundles
const TsLib = exports.TsLib = require('tslib');
const KbnAnalytics = exports.KbnAnalytics = require('@kbn/analytics');
const KbnStd = exports.KbnStd = require('@kbn/std');
const SaferLodashSet = exports.SaferLodashSet = require('@elastic/safer-lodash-set');
const RisonNode = exports.RisonNode = require('rison-node');
const History = exports.History = require('history');
const Classnames = exports.Classnames = require('classnames');