"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsImporter = void 0;
var _import_saved_objects = require("./import_saved_objects");
var _resolve_import_errors = require("./resolve_import_errors");
function _classPrivateFieldInitSpec(e, t, a) { _checkPrivateRedeclaration(e, t), t.set(e, a); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _classPrivateFieldSet(s, a, r) { return s.set(_assertClassBrand(s, a), r), r; }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * @public
 */
var _savedObjectsClient = /*#__PURE__*/new WeakMap();
var _typeRegistry = /*#__PURE__*/new WeakMap();
var _importSizeLimit = /*#__PURE__*/new WeakMap();
var _importHooks = /*#__PURE__*/new WeakMap();
/**
 * @public
 */
class SavedObjectsImporter {
  constructor({
    savedObjectsClient,
    typeRegistry,
    importSizeLimit
  }) {
    _classPrivateFieldInitSpec(this, _savedObjectsClient, void 0);
    _classPrivateFieldInitSpec(this, _typeRegistry, void 0);
    _classPrivateFieldInitSpec(this, _importSizeLimit, void 0);
    _classPrivateFieldInitSpec(this, _importHooks, void 0);
    _classPrivateFieldSet(_savedObjectsClient, this, savedObjectsClient);
    _classPrivateFieldSet(_typeRegistry, this, typeRegistry);
    _classPrivateFieldSet(_importSizeLimit, this, importSizeLimit);
    _classPrivateFieldSet(_importHooks, this, typeRegistry.getAllTypes().reduce((hooks, type) => {
      var _type$management;
      if ((_type$management = type.management) !== null && _type$management !== void 0 && _type$management.onImport) {
        return {
          ...hooks,
          [type.name]: [type.management.onImport]
        };
      }
      return hooks;
    }, {}));
  }

  /**
   * Import saved objects from given stream. See the {@link SavedObjectsImportOptions | options} for more
   * detailed information.
   *
   * @throws SavedObjectsImportError
   */
  import({
    readStream,
    createNewCopies,
    namespace,
    overwrite
  }) {
    return (0, _import_saved_objects.importSavedObjectsFromStream)({
      readStream,
      createNewCopies,
      namespace,
      overwrite,
      objectLimit: _classPrivateFieldGet(_importSizeLimit, this),
      savedObjectsClient: _classPrivateFieldGet(_savedObjectsClient, this),
      typeRegistry: _classPrivateFieldGet(_typeRegistry, this),
      importHooks: _classPrivateFieldGet(_importHooks, this)
    });
  }

  /**
   * Resolve and return saved object import errors.
   * See the {@link SavedObjectsResolveImportErrorsOptions | options} for more detailed informations.
   *
   * @throws SavedObjectsImportError
   */
  resolveImportErrors({
    readStream,
    createNewCopies,
    namespace,
    retries
  }) {
    return (0, _resolve_import_errors.resolveSavedObjectsImportErrors)({
      readStream,
      createNewCopies,
      namespace,
      retries,
      objectLimit: _classPrivateFieldGet(_importSizeLimit, this),
      savedObjectsClient: _classPrivateFieldGet(_savedObjectsClient, this),
      typeRegistry: _classPrivateFieldGet(_typeRegistry, this),
      importHooks: _classPrivateFieldGet(_importHooks, this)
    });
  }
}
exports.SavedObjectsImporter = SavedObjectsImporter;