"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = nearest;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Upsampling and downsampling of non-cumulative sets
// Good: average, min, max
// Bad: sum, count
function nearest(dataTuples, targetTuples) {
  return _lodash.default.map(targetTuples, function (bucket) {
    const time = bucket[0];
    let i = 0;
    while (i < dataTuples.length - 1 && (Math.abs(dataTuples[i + 1][0] - time) < Math.abs(dataTuples[i][0] - time) ||
    // TODO: Certain offset= args can cause buckets with duplicate times, e.g., offset=-1M
    // check for that, and only use the last of the duplicates. The reason this happens?
    // What is 1M before Mar 30th? What about 1M before Mar 31st? Both are the last day
    // in Feb. Something has to be chucked. If offsetting by M user might want to use
    // fit=average
    Math.abs(dataTuples[i + 1][0] - time) === Math.abs(dataTuples[i][0] - time))) {
      i++;
    }
    const closest = dataTuples[i];
    dataTuples.splice(0, i);
    return [bucket[0], closest[1]];
  });
}
module.exports = exports.default;