"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _i18n = require("@kbn/i18n");
var _reduce = _interopRequireDefault(require("../lib/reduce.js"));
var _chainable = _interopRequireDefault(require("../lib/classes/chainable"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _default = exports.default = new _chainable.default('multiply', {
  args: [{
    name: 'inputSeries',
    types: ['seriesList']
  }, {
    name: 'multiplier',
    types: ['seriesList', 'number'],
    help: _i18n.i18n.translate('timelion.help.functions.multiply.args.multiplierHelpText', {
      defaultMessage: 'Number or series by which to multiply. SeriesList with multiple series will be applied label-wise.'
    })
  }],
  help: _i18n.i18n.translate('timelion.help.functions.multiplyHelpText', {
    defaultMessage: 'Multiply the values of one or more series in a seriesList to each position, in each series, of the input seriesList'
  }),
  fn: function multiplyFn(args) {
    return (0, _reduce.default)(args, function (a, b) {
      return a * b;
    });
  }
});
module.exports = exports.default;