"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventMetadataRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _create_apm_server_route_repository = require("./create_apm_server_route_repository");
var _create_apm_server_route = require("./create_apm_server_route");
var _get_event_metadata = require("../lib/event_metadata/get_event_metadata");
var _processor_event = require("../../common/processor_event");
var _setup_request = require("../lib/helpers/setup_request");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const eventMetadataRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /api/apm/event_metadata/{processorEvent}/{id}',
  options: {
    tags: ['access:apm']
  },
  params: t.type({
    path: t.type({
      processorEvent: _processor_event.processorEventRt,
      id: t.string
    })
  }),
  handler: async resources => {
    const setup = await (0, _setup_request.setupRequest)(resources);
    const {
      path: {
        processorEvent,
        id
      }
    } = resources.params;
    const metadata = await (0, _get_event_metadata.getEventMetadata)({
      apmEventClient: setup.apmEventClient,
      processorEvent,
      id
    });
    return {
      metadata
    };
  }
});
const eventMetadataRouteRepository = exports.eventMetadataRouteRepository = (0, _create_apm_server_route_repository.createApmServerRouteRepository)().add(eventMetadataRoute);