"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUPPORTED_CONNECTORS = exports.SUB_CASE_USER_ACTIONS_URL = exports.SUB_CASE_SAVED_OBJECT = exports.SUB_CASE_DETAILS_URL = exports.SUB_CASES_URL = exports.SUB_CASES_PATCH_DEL_URL = exports.SECURITY_SOLUTION_OWNER = exports.SAVED_OBJECT_TYPES = exports.MAX_TITLE_LENGTH = exports.MAX_GENERATED_ALERTS_PER_SUB_CASE = exports.MAX_DOCS_PER_PAGE = exports.MAX_CONCURRENT_SEARCHES = exports.MAX_ALERTS_PER_SUB_CASE = exports.ENABLE_CASE_CONNECTOR = exports.DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT = exports.CONNECTORS_URL = exports.CASE_USER_ACTION_SAVED_OBJECT = exports.CASE_USER_ACTIONS_URL = exports.CASE_TAGS_URL = exports.CASE_STATUS_URL = exports.CASE_SAVED_OBJECT = exports.CASE_REPORTERS_URL = exports.CASE_PUSH_URL = exports.CASE_DETAILS_URL = exports.CASE_DETAILS_ALERTS_URL = exports.CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT = exports.CASE_CONFIGURE_URL = exports.CASE_CONFIGURE_SAVED_OBJECT = exports.CASE_CONFIGURE_DETAILS_URL = exports.CASE_CONFIGURE_CONNECTORS_URL = exports.CASE_COMMENT_SAVED_OBJECT = exports.CASE_COMMENT_DETAILS_URL = exports.CASE_COMMENTS_URL = exports.CASE_ALERTS_URL = exports.CASES_URL = exports.APP_ID = exports.ACTION_URL = exports.ACTION_TYPES_URL = void 0;
var _api = require("./api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATE_FORMAT = exports.DEFAULT_DATE_FORMAT = 'dateFormat';
const DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT_TZ = 'dateFormat:tz';
const APP_ID = exports.APP_ID = 'cases';
const CASE_SAVED_OBJECT = exports.CASE_SAVED_OBJECT = 'cases';
const CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT = exports.CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT = 'cases-connector-mappings';
const SUB_CASE_SAVED_OBJECT = exports.SUB_CASE_SAVED_OBJECT = 'cases-sub-case';
const CASE_USER_ACTION_SAVED_OBJECT = exports.CASE_USER_ACTION_SAVED_OBJECT = 'cases-user-actions';
const CASE_COMMENT_SAVED_OBJECT = exports.CASE_COMMENT_SAVED_OBJECT = 'cases-comments';
const CASE_CONFIGURE_SAVED_OBJECT = exports.CASE_CONFIGURE_SAVED_OBJECT = 'cases-configure';

/**
 * If more values are added here please also add them here: x-pack/test/case_api_integration/common/fixtures/plugins
 */
const SAVED_OBJECT_TYPES = exports.SAVED_OBJECT_TYPES = [CASE_SAVED_OBJECT, CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT, CASE_USER_ACTION_SAVED_OBJECT, CASE_COMMENT_SAVED_OBJECT, CASE_CONFIGURE_SAVED_OBJECT];

/**
 * Case routes
 */

const CASES_URL = exports.CASES_URL = '/api/cases';
const CASE_DETAILS_URL = exports.CASE_DETAILS_URL = `${CASES_URL}/{case_id}`;
const CASE_CONFIGURE_URL = exports.CASE_CONFIGURE_URL = `${CASES_URL}/configure`;
const CASE_CONFIGURE_DETAILS_URL = exports.CASE_CONFIGURE_DETAILS_URL = `${CASES_URL}/configure/{configuration_id}`;
const CASE_CONFIGURE_CONNECTORS_URL = exports.CASE_CONFIGURE_CONNECTORS_URL = `${CASE_CONFIGURE_URL}/connectors`;
const SUB_CASES_PATCH_DEL_URL = exports.SUB_CASES_PATCH_DEL_URL = `${CASES_URL}/sub_cases`;
const SUB_CASES_URL = exports.SUB_CASES_URL = `${CASE_DETAILS_URL}/sub_cases`;
const SUB_CASE_DETAILS_URL = exports.SUB_CASE_DETAILS_URL = `${CASE_DETAILS_URL}/sub_cases/{sub_case_id}`;
const SUB_CASE_USER_ACTIONS_URL = exports.SUB_CASE_USER_ACTIONS_URL = `${SUB_CASE_DETAILS_URL}/user_actions`;
const CASE_COMMENTS_URL = exports.CASE_COMMENTS_URL = `${CASE_DETAILS_URL}/comments`;
const CASE_COMMENT_DETAILS_URL = exports.CASE_COMMENT_DETAILS_URL = `${CASE_DETAILS_URL}/comments/{comment_id}`;
const CASE_PUSH_URL = exports.CASE_PUSH_URL = `${CASE_DETAILS_URL}/connector/{connector_id}/_push`;
const CASE_REPORTERS_URL = exports.CASE_REPORTERS_URL = `${CASES_URL}/reporters`;
const CASE_STATUS_URL = exports.CASE_STATUS_URL = `${CASES_URL}/status`;
const CASE_TAGS_URL = exports.CASE_TAGS_URL = `${CASES_URL}/tags`;
const CASE_USER_ACTIONS_URL = exports.CASE_USER_ACTIONS_URL = `${CASE_DETAILS_URL}/user_actions`;
const CASE_ALERTS_URL = exports.CASE_ALERTS_URL = `${CASES_URL}/alerts/{alert_id}`;
const CASE_DETAILS_ALERTS_URL = exports.CASE_DETAILS_ALERTS_URL = `${CASE_DETAILS_URL}/alerts`;

/**
 * Action routes
 */

const ACTION_URL = exports.ACTION_URL = '/api/actions';
const ACTION_TYPES_URL = exports.ACTION_TYPES_URL = `${ACTION_URL}/connector_types`;
const CONNECTORS_URL = exports.CONNECTORS_URL = `${ACTION_URL}/connectors`;
const SUPPORTED_CONNECTORS = exports.SUPPORTED_CONNECTORS = [`${_api.ConnectorTypes.serviceNowITSM}`, `${_api.ConnectorTypes.serviceNowSIR}`, `${_api.ConnectorTypes.jira}`, `${_api.ConnectorTypes.resilient}`, `${_api.ConnectorTypes.swimlane}`];

/**
 * Alerts
 */
const MAX_ALERTS_PER_SUB_CASE = exports.MAX_ALERTS_PER_SUB_CASE = 5000;
const MAX_GENERATED_ALERTS_PER_SUB_CASE = exports.MAX_GENERATED_ALERTS_PER_SUB_CASE = 50;

/**
 * This must be the same value that the security solution plugin uses to define the case kind when it registers the
 * feature for the 7.13 migration only.
 *
 * This variable is being also used by test files and mocks.
 */
const SECURITY_SOLUTION_OWNER = exports.SECURITY_SOLUTION_OWNER = 'securitySolution';

/**
 * This flag governs enabling the case as a connector feature. It is disabled by default as the feature is not complete.
 */
const ENABLE_CASE_CONNECTOR = exports.ENABLE_CASE_CONNECTOR = false;
if (ENABLE_CASE_CONNECTOR) {
  SAVED_OBJECT_TYPES.push(SUB_CASE_SAVED_OBJECT);
}
const MAX_DOCS_PER_PAGE = exports.MAX_DOCS_PER_PAGE = 10000;
const MAX_CONCURRENT_SEARCHES = exports.MAX_CONCURRENT_SEARCHES = 10;

/**
 * Validation
 */

const MAX_TITLE_LENGTH = exports.MAX_TITLE_LENGTH = 64;