"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatePackageRequestSchema = exports.InstallPackageFromRegistryRequestSchema = exports.InstallPackageByUploadRequestSchema = exports.GetStatsRequestSchema = exports.GetPackagesRequestSchema = exports.GetInfoRequestSchema = exports.GetFileRequestSchema = exports.GetCategoriesRequestSchema = exports.DeletePackageRequestSchema = exports.BulkUpgradePackagesFromRegistryRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetCategoriesRequestSchema = exports.GetCategoriesRequestSchema = {
  query: _configSchema.schema.object({
    experimental: _configSchema.schema.maybe(_configSchema.schema.boolean()),
    include_policy_templates: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const GetPackagesRequestSchema = exports.GetPackagesRequestSchema = {
  query: _configSchema.schema.object({
    category: _configSchema.schema.maybe(_configSchema.schema.string()),
    experimental: _configSchema.schema.maybe(_configSchema.schema.boolean())
  })
};
const GetFileRequestSchema = exports.GetFileRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string(),
    pkgVersion: _configSchema.schema.string(),
    filePath: _configSchema.schema.string()
  })
};
const GetInfoRequestSchema = exports.GetInfoRequestSchema = {
  params: _configSchema.schema.object({
    pkgkey: _configSchema.schema.string()
  })
};
const UpdatePackageRequestSchema = exports.UpdatePackageRequestSchema = {
  params: _configSchema.schema.object({
    pkgkey: _configSchema.schema.string()
  }),
  body: _configSchema.schema.object({
    keepPoliciesUpToDate: _configSchema.schema.boolean()
  })
};
const GetStatsRequestSchema = exports.GetStatsRequestSchema = {
  params: _configSchema.schema.object({
    pkgName: _configSchema.schema.string()
  })
};
const InstallPackageFromRegistryRequestSchema = exports.InstallPackageFromRegistryRequestSchema = {
  params: _configSchema.schema.object({
    pkgkey: _configSchema.schema.string()
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    force: _configSchema.schema.boolean()
  }))
};
const BulkUpgradePackagesFromRegistryRequestSchema = exports.BulkUpgradePackagesFromRegistryRequestSchema = {
  body: _configSchema.schema.object({
    packages: _configSchema.schema.arrayOf(_configSchema.schema.string(), {
      minSize: 1
    })
  })
};
const InstallPackageByUploadRequestSchema = exports.InstallPackageByUploadRequestSchema = {
  body: _configSchema.schema.buffer()
};
const DeletePackageRequestSchema = exports.DeletePackageRequestSchema = {
  params: _configSchema.schema.object({
    pkgkey: _configSchema.schema.string()
  }),
  body: _configSchema.schema.nullable(_configSchema.schema.object({
    force: _configSchema.schema.boolean()
  }))
};