"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StorybookContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _history = require("history");
var _react2 = require("@kbn/i18n/react");
var _public = require("../../../../../src/core/public");
var _storybook = require("../../../../../src/plugins/custom_integrations/storybook");
var _app = require("../../public/applications/integrations/app");
var _use_request = require("../../public/hooks/use_request");
var _custom_integrations = require("../../public/services/custom_integrations");
var _application = require("./application");
var _chrome = require("./chrome");
var _http = require("./http");
var _ui_settings = require("./ui_settings");
var _notifications = require("./notifications");
var _stubs = require("./stubs");
var _doc_links = require("./doc_links");
var _cloud = require("./cloud");
var _share = require("./share");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
} /*
  * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
  * or more contributor license agreements. Licensed under the Elastic License
  * 2.0; you may not use this file except in compliance with the Elastic License
  * 2.0.
  */ // TODO: These are contract leaks, and should be on the context, rather than a setter.
// TODO: clintandrewhall - this is not ideal, or complete.  The root context of Fleet applications
// requires full start contracts of its dependencies.  As a result, we have to mock all of those contracts
// with Storybook equivalents.  This is a temporary solution, and should be replaced with a more complete
// mock later, (or, ideally, Fleet starts to use a service abstraction).
//
// Expect this to grow as components that are given Stories need access to mocked services.
const StorybookContext = ({
  storyContext,
  children: storyChildren
}) => {
  const basepath = '';
  const browserHistory = (0, _history.createBrowserHistory)();
  const history = new _public.ScopedHistory(browserHistory, basepath);
  const startServices = {
    ..._stubs.stubbedStartServices,
    application: (0, _application.getApplication)(),
    chrome: (0, _chrome.getChrome)(),
    cloud: (0, _cloud.getCloud)({
      isCloudEnabled: storyContext === null || storyContext === void 0 ? void 0 : storyContext.args.isCloudEnabled
    }),
    customIntegrations: {
      ContextProvider: (0, _storybook.getStorybookContextProvider)()
    },
    docLinks: (0, _doc_links.getDocLinks)(),
    http: (0, _http.getHttp)(),
    i18n: {
      Context: function I18nContext({
        children
      }) {
        return /*#__PURE__*/_react.default.createElement(_react2.I18nProvider, null, children);
      }
    },
    injectedMetadata: {
      getInjectedVar: () => null
    },
    notifications: (0, _notifications.getNotifications)(),
    share: (0, _share.getShare)(),
    uiSettings: (0, _ui_settings.getUiSettings)()
  };
  (0, _use_request.setHttpClient)(startServices.http);
  (0, _custom_integrations.setCustomIntegrations)({
    getAppendCustomIntegrations: async () => [],
    getReplacementCustomIntegrations: async () => {
      const {
        integrations
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./fixtures/replacement_integrations')));
      return integrations;
    }
  });
  const config = {
    enabled: true,
    agents: {
      enabled: true,
      elasticsearch: {}
    }
  };
  const extensions = {};
  const kibanaVersion = '1.2.3';
  const setHeaderActionMenu = () => {};
  return /*#__PURE__*/_react.default.createElement(_app.IntegrationsAppContext, {
    kibanaVersion,
    basepath,
    config,
    history,
    startServices,
    extensions,
    setHeaderActionMenu
  }, storyChildren);
};
exports.StorybookContext = StorybookContext;