"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNodesTimeseriesRowRT = exports.TopNodesSeriesRT = exports.TopNodesResponseRT = exports.TopNodesRequestRT = exports.OverviewResponseRT = exports.OverviewRequestRT = exports.OverviewMetricTypeRT = exports.OverviewMetricRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OverviewMetricTypeRT = exports.OverviewMetricTypeRT = rt.keyof({
  percent: null,
  number: null,
  bytesPerSecond: null
});
const OverviewMetricRT = exports.OverviewMetricRT = rt.type({
  type: rt.string,
  value: rt.number
});
const OverviewResponseRT = exports.OverviewResponseRT = rt.type({
  stats: rt.type({
    hosts: OverviewMetricRT,
    cpu: OverviewMetricRT,
    memory: OverviewMetricRT
  })
});
const OverviewRequestRT = exports.OverviewRequestRT = rt.type({
  sourceId: rt.string,
  timerange: rt.type({
    from: rt.number,
    to: rt.number
  })
});
const TopNodesRequestRT = exports.TopNodesRequestRT = rt.intersection([rt.type({
  sourceId: rt.string,
  size: rt.number,
  bucketSize: rt.string,
  timerange: rt.type({
    from: rt.number,
    to: rt.number
  })
}), rt.partial({
  sort: rt.string,
  sortDirection: rt.string
})]);
const numberOrNullRT = rt.union([rt.number, rt.null]);
const stringOrNullRT = rt.union([rt.string, rt.null]);
const TopNodesTimeseriesRowRT = exports.TopNodesTimeseriesRowRT = rt.type({
  timestamp: rt.number,
  cpu: numberOrNullRT,
  iowait: numberOrNullRT,
  load: numberOrNullRT,
  rx: numberOrNullRT,
  tx: numberOrNullRT
});
const TopNodesSeriesRT = exports.TopNodesSeriesRT = rt.type({
  id: rt.string,
  name: stringOrNullRT,
  platform: stringOrNullRT,
  provider: stringOrNullRT,
  cpu: numberOrNullRT,
  iowait: numberOrNullRT,
  load: numberOrNullRT,
  uptime: numberOrNullRT,
  rx: numberOrNullRT,
  tx: numberOrNullRT,
  timeseries: rt.array(TopNodesTimeseriesRowRT)
});
const TopNodesResponseRT = exports.TopNodesResponseRT = rt.type({
  series: rt.array(TopNodesSeriesRT)
});