"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logEntriesSearchResponsePayloadRT = exports.logEntriesSearchRequestParamsRT = exports.logEntriesBeforeSearchRequestParamsRT = exports.logEntriesAfterSearchRequestParamsRT = exports.LOG_ENTRIES_SEARCH_STRATEGY = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _log_source_configuration = require("../../log_sources/log_source_configuration");
var _log_entry = require("../../log_entry");
var _typed_json = require("../../typed_json");
var _errors = require("../common/errors");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOG_ENTRIES_SEARCH_STRATEGY = exports.LOG_ENTRIES_SEARCH_STRATEGY = 'infra-log-entries';
const logEntriesBaseSearchRequestParamsRT = rt.intersection([rt.type({
  sourceId: rt.string,
  startTimestamp: rt.number,
  endTimestamp: rt.number,
  size: rt.number
}), rt.partial({
  query: _typed_json.jsonObjectRT,
  columns: rt.array(_log_source_configuration.logSourceColumnConfigurationRT),
  highlightPhrase: rt.string
})]);
const logEntriesBeforeSearchRequestParamsRT = exports.logEntriesBeforeSearchRequestParamsRT = rt.intersection([logEntriesBaseSearchRequestParamsRT, _log_entry.logEntryBeforeCursorRT]);
const logEntriesAfterSearchRequestParamsRT = exports.logEntriesAfterSearchRequestParamsRT = rt.intersection([logEntriesBaseSearchRequestParamsRT, _log_entry.logEntryAfterCursorRT]);
const logEntriesSearchRequestParamsRT = exports.logEntriesSearchRequestParamsRT = rt.union([logEntriesBaseSearchRequestParamsRT, logEntriesBeforeSearchRequestParamsRT, logEntriesAfterSearchRequestParamsRT]);
const logEntriesSearchResponsePayloadRT = exports.logEntriesSearchResponsePayloadRT = rt.intersection([rt.type({
  data: rt.intersection([rt.type({
    entries: rt.array(_log_entry.logEntryRT),
    topCursor: rt.union([_log_entry.logEntryCursorRT, rt.null]),
    bottomCursor: rt.union([_log_entry.logEntryCursorRT, rt.null])
  }), rt.partial({
    hasMoreBefore: rt.boolean,
    hasMoreAfter: rt.boolean
  })])
}), rt.partial({
  errors: rt.array(_errors.searchStrategyErrorRT)
})]);