"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateAuto = void 0;
var _moment = _interopRequireWildcard(require("moment"));
var _lodash = require("lodash");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const d = _moment.default.duration;
const roundingRules = [[d(500, 'ms'), d(100, 'ms')], [d(5, 'second'), d(1, 'second')], [d(7.5, 'second'), d(5, 'second')], [d(15, 'second'), d(10, 'second')], [d(45, 'second'), d(30, 'second')], [d(3, 'minute'), d(1, 'minute')], [d(9, 'minute'), d(5, 'minute')], [d(20, 'minute'), d(10, 'minute')], [d(45, 'minute'), d(30, 'minute')], [d(2, 'hour'), d(1, 'hour')], [d(6, 'hour'), d(3, 'hour')], [d(24, 'hour'), d(12, 'hour')], [d(1, 'week'), d(1, 'd')], [d(3, 'week'), d(1, 'week')], [d(1, 'year'), d(1, 'month')], [Infinity, d(1, 'year')]];
const revRoundingRules = [...roundingRules].reverse();
function findRule(rules, check, last) {
  function pickInterval(buckets, duration) {
    const target = duration.asMilliseconds() / buckets;
    let lastResult = null;
    for (const rule of rules) {
      const result = check(rule[0], rule[1], target);
      if (result == null) {
        if (!last) continue;
        if (lastResult) return lastResult;
        break;
      }
      if (!last) return result;
      lastResult = result;
    }

    // fallback to just a number of milliseconds, ensure ms is >= 1
    const ms = Math.max(Math.floor(target), 1);
    return _moment.default.duration(ms, 'ms');
  }
  return (buckets, duration) => {
    const interval = pickInterval(buckets, duration);
    if ((0, _moment.isDuration)(interval)) return interval;
  };
}
const calculateAuto = exports.calculateAuto = {
  near: findRule(revRoundingRules, function near(bound, interval, target) {
    if ((0, _moment.isDuration)(bound) && bound.asMilliseconds() > target) return interval;
    if ((0, _lodash.isNumber)(bound) && bound > target) return interval;
  }, true),
  lessThan: findRule(revRoundingRules, function lessThan(_bound, interval, target) {
    if (interval.asMilliseconds() < target) return interval;
  }),
  atLeast: findRule(revRoundingRules, function atLeast(_bound, interval, target) {
    if (interval.asMilliseconds() <= target) return interval;
  })
};