"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REFERENCE = exports.PROVIDER = exports.MATCHED_TYPE = exports.MATCHED_ID = exports.MATCHED_FIELD = exports.MATCHED_ATOMIC = exports.LAST_SEEN = exports.INDICATOR_REFERENCE = exports.INDICATOR_PROVIDER = exports.INDICATOR_MATCH_SUBFIELDS = exports.INDICATOR_MATCHED_TYPE = exports.INDICATOR_MATCHED_FIELD = exports.INDICATOR_MATCHED_ATOMIC = exports.INDICATOR_LASTSEEN = exports.INDICATOR_FIRSTSEEN = exports.FIRST_SEEN = exports.EVENT_ENRICHMENT_INDICATOR_FIELD_MAP = exports.EVENT_DATASET = exports.ENRICHMENT_TYPES = exports.DEFAULT_EVENT_ENRICHMENT_TO = exports.DEFAULT_EVENT_ENRICHMENT_FROM = exports.CTI_ROW_RENDERER_FIELDS = exports.CTI_DATASET_KEY_MAP = void 0;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MATCHED_ATOMIC = exports.MATCHED_ATOMIC = 'matched.atomic';
const MATCHED_FIELD = exports.MATCHED_FIELD = 'matched.field';
const MATCHED_ID = exports.MATCHED_ID = 'matched.id';
const MATCHED_TYPE = exports.MATCHED_TYPE = 'matched.type';
const INDICATOR_MATCH_SUBFIELDS = exports.INDICATOR_MATCH_SUBFIELDS = [MATCHED_ATOMIC, MATCHED_FIELD, MATCHED_TYPE];
const INDICATOR_MATCHED_ATOMIC = exports.INDICATOR_MATCHED_ATOMIC = `${_constants.ENRICHMENT_DESTINATION_PATH}.${MATCHED_ATOMIC}`;
const INDICATOR_MATCHED_FIELD = exports.INDICATOR_MATCHED_FIELD = `${_constants.ENRICHMENT_DESTINATION_PATH}.${MATCHED_FIELD}`;
const INDICATOR_MATCHED_TYPE = exports.INDICATOR_MATCHED_TYPE = `${_constants.ENRICHMENT_DESTINATION_PATH}.${MATCHED_TYPE}`;
const EVENT_DATASET = exports.EVENT_DATASET = 'event.dataset';
const FIRST_SEEN = exports.FIRST_SEEN = 'indicator.first_seen';
const LAST_SEEN = exports.LAST_SEEN = 'indicator.last_seen';
const PROVIDER = exports.PROVIDER = 'indicator.provider';
const REFERENCE = exports.REFERENCE = 'indicator.reference';
const INDICATOR_FIRSTSEEN = exports.INDICATOR_FIRSTSEEN = `${_constants.ENRICHMENT_DESTINATION_PATH}.${FIRST_SEEN}`;
const INDICATOR_LASTSEEN = exports.INDICATOR_LASTSEEN = `${_constants.ENRICHMENT_DESTINATION_PATH}.${LAST_SEEN}`;
const INDICATOR_PROVIDER = exports.INDICATOR_PROVIDER = `${_constants.ENRICHMENT_DESTINATION_PATH}.${PROVIDER}`;
const INDICATOR_REFERENCE = exports.INDICATOR_REFERENCE = `${_constants.ENRICHMENT_DESTINATION_PATH}.${REFERENCE}`;
const CTI_ROW_RENDERER_FIELDS = exports.CTI_ROW_RENDERER_FIELDS = [INDICATOR_MATCHED_ATOMIC, INDICATOR_MATCHED_FIELD, INDICATOR_MATCHED_TYPE, INDICATOR_REFERENCE, INDICATOR_PROVIDER];
let ENRICHMENT_TYPES = exports.ENRICHMENT_TYPES = /*#__PURE__*/function (ENRICHMENT_TYPES) {
  ENRICHMENT_TYPES["InvestigationTime"] = "investigation_time";
  ENRICHMENT_TYPES["IndicatorMatchRule"] = "indicator_match_rule";
  return ENRICHMENT_TYPES;
}({});
const EVENT_ENRICHMENT_INDICATOR_FIELD_MAP = exports.EVENT_ENRICHMENT_INDICATOR_FIELD_MAP = {
  'file.hash.md5': 'threatintel.indicator.file.hash.md5',
  'file.hash.sha1': 'threatintel.indicator.file.hash.sha1',
  'file.hash.sha256': 'threatintel.indicator.file.hash.sha256',
  'file.pe.imphash': 'threatintel.indicator.file.pe.imphash',
  'file.elf.telfhash': 'threatintel.indicator.file.elf.telfhash',
  'file.hash.ssdeep': 'threatintel.indicator.file.hash.ssdeep',
  'source.ip': 'threatintel.indicator.ip',
  'destination.ip': 'threatintel.indicator.ip',
  'url.full': 'threatintel.indicator.url.full',
  'registry.path': 'threatintel.indicator.registry.path'
};
const DEFAULT_EVENT_ENRICHMENT_FROM = exports.DEFAULT_EVENT_ENRICHMENT_FROM = 'now-30d';
const DEFAULT_EVENT_ENRICHMENT_TO = exports.DEFAULT_EVENT_ENRICHMENT_TO = 'now';
const CTI_DATASET_KEY_MAP = exports.CTI_DATASET_KEY_MAP = {
  'Abuse URL': 'threatintel.abuseurl',
  'Abuse Malware': 'threatintel.abusemalware',
  'AlienVault OTX': 'threatintel.otx',
  Anomali: 'threatintel.anomali',
  'Malware Bazaar': 'threatintel.malwarebazaar',
  MISP: 'threatintel.misp',
  'Recorded Future': 'threatintel.recordedfuture'
};