#include "atlas_asm.h"
/*
 * 1 at memory means locked, 0 means unlocked
 * w0                x0
 * int ATL_lock(void *lck);
 * RETURNS: 0 if lock was obtained, else 1
 */
#define one %cl
.text
.global ATL_asmdecor(ATL_lock)
ATL_asmdecor(ATL_lock):
   .local LOOP
   mov x1, x0
   mov w2, 1
   LOOP:
      ldxrb w0, [x1]     /* exclusive read of 0/1 into reg reg */
      stxrb w3, w2, [x1] /* store 1, w3 0 on exclusive success */
   cbnz w3, WAIT         /* if exclusive failed, wait & try again */
   cbnz w0, WAIT         /* if already locked, wait & try again */
   ret
.local WAIT:
WAIT:
   YIELD
   jmp LOOP
