Test 15-03 - Appliance and Network Settings

# Purpose:
To verify that the guest OS deployed using built ova has user specified appliance and network settings

# Environment:
This test requires that a vCenter and a vSphere server are running and available

# Test Steps:
1. Deploy Unified OVA to vCenter with provided network parameters
2. For loop on a GOVC command to query guest network information until returned result is not null or maximum retry reached
3. Issue a GOVC command to get the IP addresses for "VM Network"
4. Issue a GOVC command to get the subnet netmask for the first IP address in "VM Network"
5. Issue a GOVC command to get the dhcp option for guest os
6. Issue a GOVC command to get the dns address for guest os
7. Issue a GOVC command to get the dns searchdomains for guest os
8. Issue a GOVC command to check disk size('disk-1000-1') for guest os
9. Issue a GOVC command to resize disk-1000-1 and assure the resizing works
10. Remove deployed Unified OVA, Redeploy Unified OVA to vCenter without network parameters(dhcp by default)
11. Issue a GOVC command to make sure the first ip address under "VM Network" is an IPv4 address(including three '.' in address)

# Expected Outcome:
* Step 2 should exit for loop on a non-null network information
* Step 3 should result in an output where 'ips' contains '${ova_network_ip0}'
* Step 4 should result in an output where 'netmask' should be 24
* Step 5 should result in an output where 'dhcp' should be false
* Step 6 should result in an output where 'dns' should be '${ova_network_dns}'
* Step 7 should result in an output where 'search_domains' should be 'ova_network_searchpath'
* Step 8 should result in an output where 'size' should be '${ova_default_disk_size_inKB}'
* Step 9 should successfully resize 'disk-1000-1' and result in an output where 'size' being '${ova_adjusted_disk_size_inKB}'

# Possible Problems:
* Step 2 exit for loop when maximum retry reached, meaning guest network has not been configured yet, which will fail this test
