/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "utils.h"

char *tax_types[] = {
    "Income",
    "Property",
    "Business_Income",
    "Sales"
};

extern char *
prettyprint_money(int num, char *str, int lenstr)
{
    char *negative = "";

    if (num < 0) {
	num *= -1;
	negative = "-";
    }

    if (num >= 1000*1000*1000) {
	snprintf(str,lenstr,"%s$%.2fB",negative, ((float)num)/(1000*1000*1000));
    } else if (num >= 1000*1000) {
	snprintf(str,lenstr,"%s$%.2fM",negative, ((float)num)/(1000*1000));
    } else if (num >= 1000) {
	snprintf(str,lenstr,"%s$%d,%03d",negative,num/1000, num%1000);
    } else {
	snprintf(str,lenstr,"%s$%d",negative,num);
    }    

    return str;
}

extern int
labor_count(labor_t *labor)
{
    int i;
    int num = 0;

    for (i = 0; i < LABOR_NUMGROUPS; i++) {
	num += labor->workers[i];
    }

    return num;
}

extern int
set_map_byname(map_t *map, int x, int y, char *name, int force)
{
    mapobj_t obj = map_item_name2obj(name);
    return map_set_type(map, x, y, obj, force);
}
