/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class LinuxFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private String osType;
    private int[] features;
    private String homePath = "";
    private String readline = "";
    private String password;
    private int installSuccess;
    private int needJavaHome = 0;
    private String currentDir = "";
    private String installerShell = "";
    private String installerLog = "";
    private JPanel infoContentPane = null;
    private JPanel featureContentPane = null;
    private JPanel jdkPathContentPane = null;
    private JPanel installContentPane = null;
    private JPanel compileContentPane = null;
    private JPanel finishContentPane = null;
    private JButton infoPrevButton = null;
    private JButton infoNextButton = null;
    private JButton featurePrevButton = null;
    private JButton featureNextButton = null;
    private JButton jdkPathPrevButton = null;
    private JButton jdkPathNextButton = null;
    private JButton installPrevButton = null;
    private JButton installNextButton = null;
    private JButton compilePrevButton = null;
    private JButton compileNextButton = null;
    private JButton finishPrevButton = null;
    private JButton finishNextButton = null;
    private JCheckBox dbCheckBox = null;
    private JCheckBox httpCheckBox = null;
    private JCheckBox xmlCheckBox = null;
    private JCheckBox regCheckBox = null;
    private JCheckBox javaCheckBox = null;
    private JLabel infoLabel = null;
    private JLabel featureLabel = null;
    private JLabel jdkPathLabel = null;
    private JLabel installLabel = null;
    private JLabel compileLabel = null;
    private JLabel finishSuccessLabel = null;
    private JLabel finishFailLabel = null;
    private JScrollPane installScrollPane = null;
    private JTextArea installTextArea = null;
    private JScrollPane compileScrollPane = null;
    private JTextArea compileTextArea = null;
    private JTextField jdkPathTextField = null;
    private JButton jdkPathChooseButton = null;

    public LinuxFrame() {
        this.initialize();
    }

    public LinuxFrame(String osType) {
        this.osType = osType;
        this.features = new int[5];
        this.initialize();
    }

    private void initialize() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        this.setSize(screenWidth / 4 * 3, screenHeight / 4 * 3);
        this.setLocation(screenWidth / 8, screenHeight / 8);
        this.setContentPane(this.getInfoContentPane());
        this.setTitle("XSB Installation");
        this.setResizable(false);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
        try {
            this.currentDir = MainRun.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            this.currentDir = this.currentDir.substring(0, this.currentDir.lastIndexOf(47) + 1);
            this.installerShell = this.currentDir + "installer/unixinstall.sh " + this.currentDir + " ";
            this.installerLog = this.currentDir + "Installer.log";
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private int getFrameHeight() {
        return this.getHeight();
    }

    private int getFrameWidth() {
        return this.getWidth();
    }

    private JPanel getInfoContentPane() {
        if (this.infoContentPane == null) {
            this.infoContentPane = new JPanel();
            this.infoContentPane.setLayout(null);
            this.infoContentPane.add(this.getInfoLabel());
            this.infoContentPane.add(this.getInfoNextButton());
            this.infoContentPane.add(this.getInfoPrevButton());
        }
        return this.infoContentPane;
    }

    private JButton getInfoPrevButton() {
        if (this.infoPrevButton == null) {
            this.infoPrevButton = new JButton();
            this.infoPrevButton.setText("Previous");
            this.infoPrevButton.setEnabled(false);
            this.infoPrevButton.setBounds(200, this.getFrameHeight() - 100, 100, 30);
        }
        return this.infoPrevButton;
    }

    private JButton getInfoNextButton() {
        if (this.infoNextButton == null) {
            this.infoNextButton = new JButton();
            this.infoNextButton.setText("Next");
            this.infoNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 100, 100, 30);
            this.infoNextButton.addActionListener(new InfoNextListener());
        }
        return this.infoNextButton;
    }

    private JLabel getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = new JLabel();
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h2>Selecting features:</h2><p>On the next page you will be offered several options for XSB installation. Some of these options may require installing additional packages for your system. In turn, this requires that your username is in the <i>sudoer list</i>. To confirm this, open the file <u>/etc/sudoers</u> and verify that the line:</p><<h3>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<i>your-user-name</i>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ALL=(ALL)&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ALL</h3><p>is there. If not, you will have to login as <u>root</u> and add the above line to that file.</p><br/><h2>No root access:</h2><p>If the above steps cannot be performed because you are not a sudoer and have no root access, XSB will be installed with whatever features are possible given your configuration. Note: all the features on the next page are <i>optional</i>, so you will be getting a functioning copy of XSB in any case.</p><br/></body></html>";
            this.infoLabel.setText(message);
            this.infoLabel.setBounds(30, 20, 650, 400);
        }
        return this.infoLabel;
    }

    private JPanel getFeatureContentPane() {
        if (this.featureContentPane == null) {
            this.featureContentPane = new JPanel();
            this.featureContentPane.setLayout(null);
            this.featureContentPane.add((Component)this.getDbCheckBox(), null);
            this.featureContentPane.add((Component)this.getHttpCheckBox(), null);
            this.featureContentPane.add((Component)this.getXmlCheckBox(), null);
            this.featureContentPane.add((Component)this.getRegCheckBox(), null);
            this.featureContentPane.add((Component)this.getJavaCheckBox(), null);
            this.featureContentPane.add((Component)this.getFeaturePrevButton(), null);
            this.featureContentPane.add((Component)this.getFeatureNextButton(), null);
            this.featureContentPane.add((Component)this.getFeatureLabel(), null);
        }
        return this.featureContentPane;
    }

    private JButton getFeaturePrevButton() {
        if (this.featurePrevButton == null) {
            this.featurePrevButton = new JButton();
            this.featurePrevButton.setText("Previous");
            this.featurePrevButton.setBounds(200, this.getFrameHeight() - 100, 100, 30);
            this.featurePrevButton.addActionListener(new FeaturePrevListener());
        }
        return this.featurePrevButton;
    }

    private JButton getFeatureNextButton() {
        if (this.featureNextButton == null) {
            this.featureNextButton = new JButton();
            this.featureNextButton.setText("Next");
            this.featureNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 100, 100, 30);
            this.featureNextButton.addActionListener(new FeatureNextListener());
        }
        return this.featureNextButton;
    }

    private JLabel getFeatureLabel() {
        if (this.featureLabel == null) {
            this.featureLabel = new JLabel();
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h3>Please choose the features you would like to install XSB with.</h3><h3>If you need faster XSB-Java interface, please install JDK and set the JAVA_HOME environment variable.</h3></body></html>";
            this.featureLabel.setText(message);
            this.featureLabel.setBounds(30, 20, 600, 150);
        }
        return this.featureLabel;
    }

    private JCheckBox getDbCheckBox() {
        if (this.dbCheckBox == null) {
            this.dbCheckBox = new JCheckBox();
            this.dbCheckBox.setText("Database drivers");
            this.dbCheckBox.setBounds(30, 200, 190, 30);
            if (this.features[0] == 1) {
                this.dbCheckBox.setSelected(true);
            }
        }
        return this.dbCheckBox;
    }

    private JCheckBox getHttpCheckBox() {
        if (this.httpCheckBox == null) {
            this.httpCheckBox = new JCheckBox();
            this.httpCheckBox.setText("HTTP access");
            this.httpCheckBox.setBounds(30, 250, 190, 30);
            if (this.features[1] == 1) {
                this.httpCheckBox.setSelected(true);
            }
        }
        return this.httpCheckBox;
    }

    private JCheckBox getXmlCheckBox() {
        if (this.xmlCheckBox == null) {
            this.xmlCheckBox = new JCheckBox();
            this.xmlCheckBox.setText("XML parsing");
            this.xmlCheckBox.setBounds(30, 300, 190, 30);
            if (this.features[2] == 1) {
                this.xmlCheckBox.setSelected(true);
            }
        }
        return this.xmlCheckBox;
    }

    private JCheckBox getRegCheckBox() {
        if (this.regCheckBox == null) {
            this.regCheckBox = new JCheckBox();
            this.regCheckBox.setText("Regular expressions");
            this.regCheckBox.setBounds(250, 200, 190, 30);
            if (this.features[3] == 1) {
                this.regCheckBox.setSelected(true);
            }
        }
        return this.regCheckBox;
    }

    private JCheckBox getJavaCheckBox() {
        if (this.javaCheckBox == null) {
            this.javaCheckBox = new JCheckBox();
            this.javaCheckBox.setText("Faster Java interface");
            this.javaCheckBox.setBounds(250, 250, 190, 30);
            if (this.features[4] == 1) {
                this.javaCheckBox.setSelected(true);
            }
        }
        return this.javaCheckBox;
    }

    private JPanel getJdkPathContentPane() {
        if (this.jdkPathContentPane == null) {
            this.jdkPathContentPane = new JPanel();
            this.jdkPathContentPane.setLayout(null);
            this.jdkPathContentPane.add((Component)this.getJdkPathPrevButton(), null);
            this.jdkPathContentPane.add((Component)this.getJdkPathNextButton(), null);
            this.jdkPathContentPane.add((Component)this.getJdkPathLabel(), null);
            this.jdkPathContentPane.add((Component)this.getJdkPathTextField(), null);
            this.jdkPathContentPane.add((Component)this.getJdkPathChooseButton(), null);
        }
        return this.jdkPathContentPane;
    }

    private JButton getJdkPathPrevButton() {
        if (this.jdkPathPrevButton == null) {
            this.jdkPathPrevButton = new JButton();
            this.jdkPathPrevButton.setText("Previous");
            this.jdkPathPrevButton.setBounds(200, this.getFrameHeight() - 100, 100, 30);
            this.jdkPathPrevButton.addActionListener(new JdkPathPrevListener());
        }
        return this.jdkPathPrevButton;
    }

    private JButton getJdkPathNextButton() {
        if (this.jdkPathNextButton == null) {
            this.jdkPathNextButton = new JButton();
            this.jdkPathNextButton.setText("Next");
            this.jdkPathNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 100, 100, 30);
            this.jdkPathNextButton.addActionListener(new JdkPathNextListener());
        }
        return this.jdkPathNextButton;
    }

    private JButton getJdkPathChooseButton() {
        if (this.jdkPathChooseButton == null) {
            this.jdkPathChooseButton = new JButton();
            this.jdkPathChooseButton.setText("Browse");
            this.jdkPathChooseButton.setBounds(340, 250, 100, 30);
            this.jdkPathChooseButton.addActionListener(new JdkPathChooseListener());
        }
        return this.jdkPathChooseButton;
    }

    private JTextField getJdkPathTextField() {
        if (this.jdkPathTextField == null) {
            this.jdkPathTextField = new JTextField();
            this.jdkPathTextField.setBounds(30, 250, 300, 30);
        }
        return this.jdkPathTextField;
    }

    private JLabel getJdkPathLabel() {
        if (this.jdkPathLabel == null) {
            this.jdkPathLabel = new JLabel();
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h3>The environment variable JAVA_HOME has not been set.</h3><br/><h3>Please enter the folder where JDK resides on your system:</h3><br/></body></html>";
            this.jdkPathLabel.setText(message);
            this.jdkPathLabel.setBounds(30, 20, 600, 200);
        }
        return this.jdkPathLabel;
    }

    private JPanel getInstallContentPane() {
        if (this.installContentPane == null) {
            this.installContentPane = new JPanel();
            this.installContentPane.setLayout(null);
            this.installContentPane.add((Component)this.getInstallScrollPane(), null);
            this.installContentPane.add((Component)this.getInstallPrevButton(), null);
            this.installContentPane.add((Component)this.getInstallNextButton(), null);
            this.installContentPane.add((Component)this.getInstallLabel(), null);
            this.installation();
        }
        return this.installContentPane;
    }

    private JScrollPane getInstallScrollPane() {
        if (this.installScrollPane == null) {
            this.installScrollPane = new JScrollPane();
            this.installScrollPane.setBounds(10, 60, this.getFrameWidth() - 20, this.getFrameHeight() - 160);
            this.installScrollPane.setViewportView(this.getInstallTextArea());
            this.getInstallTextArea().setLineWrap(true);
        }
        return this.installScrollPane;
    }

    private JTextArea getInstallTextArea() {
        if (this.installTextArea == null) {
            this.installTextArea = new JTextArea();
        }
        return this.installTextArea;
    }

    private JButton getInstallPrevButton() {
        if (this.installPrevButton == null) {
            this.installPrevButton = new JButton();
            this.installPrevButton.setText("Previous");
            this.installPrevButton.setBounds(200, this.getFrameHeight() - 80, 100, 30);
            this.installPrevButton.setEnabled(false);
        }
        return this.installPrevButton;
    }

    private JButton getInstallNextButton() {
        if (this.installNextButton == null) {
            this.installNextButton = new JButton();
            this.installNextButton.setText("Next");
            this.installNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 80, 100, 30);
            this.installNextButton.setEnabled(false);
            this.installNextButton.addActionListener(new InstallNextListener());
        }
        return this.installNextButton;
    }

    private JLabel getInstallLabel() {
        if (this.installLabel == null) {
            this.installLabel = new JLabel();
            String message = "<html><body><h1>The required packages are being installed</h1></body></html>";
            this.installLabel.setText(message);
            this.installLabel.setBounds(30, 0, 600, 50);
        }
        return this.installLabel;
    }

    private JPanel getCompileContentPane() {
        if (this.compileContentPane == null) {
            this.compileContentPane = new JPanel();
            this.compileContentPane.setLayout(null);
            this.compileContentPane.add((Component)this.getCompileScrollPane(), null);
            this.compileContentPane.add((Component)this.getCompilePrevButton(), null);
            this.compileContentPane.add((Component)this.getCompileNextButton(), null);
            this.compileContentPane.add((Component)this.getCompileLabel(), null);
            this.compilation();
        }
        return this.compileContentPane;
    }

    private JScrollPane getCompileScrollPane() {
        if (this.compileScrollPane == null) {
            this.compileScrollPane = new JScrollPane();
            this.compileScrollPane.setBounds(10, 60, this.getFrameWidth() - 20, this.getFrameHeight() - 160);
            this.compileScrollPane.setViewportView(this.getCompileTextArea());
            this.getCompileTextArea().setLineWrap(true);
        }
        return this.compileScrollPane;
    }

    private JTextArea getCompileTextArea() {
        if (this.compileTextArea == null) {
            this.compileTextArea = new JTextArea();
        }
        return this.compileTextArea;
    }

    private JButton getCompilePrevButton() {
        if (this.compilePrevButton == null) {
            this.compilePrevButton = new JButton();
            this.compilePrevButton.setText("Previous");
            this.compilePrevButton.setBounds(200, this.getFrameHeight() - 80, 100, 30);
            this.compilePrevButton.setEnabled(false);
        }
        return this.compilePrevButton;
    }

    private JButton getCompileNextButton() {
        if (this.compileNextButton == null) {
            this.compileNextButton = new JButton();
            this.compileNextButton.setText("Next");
            this.compileNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 80, 100, 30);
            this.compileNextButton.setEnabled(false);
            this.compileNextButton.addActionListener(new CompileNextListener());
        }
        return this.compileNextButton;
    }

    private JLabel getCompileLabel() {
        if (this.compileLabel == null) {
            this.compileLabel = new JLabel();
            String message = "<html><body><h1>XSB is being compiled ...</h1></body></html>";
            this.compileLabel.setText(message);
            this.compileLabel.setBounds(30, 0, 600, 50);
        }
        return this.compileLabel;
    }

    private JPanel getFinishContentPane() {
        if (this.finishContentPane == null) {
            this.finishContentPane = new JPanel();
            this.finishContentPane.setLayout(null);
            if (this.installSuccess == 1) {
                this.finishContentPane.add(this.getFinishSuccessLabel());
            } else {
                this.finishContentPane.add(this.getFinishFailLabel());
            }
            this.finishContentPane.add(this.getFinishNextButton());
            this.finishContentPane.add(this.getFinishPrevButton());
        }
        return this.finishContentPane;
    }

    private JButton getFinishPrevButton() {
        if (this.finishPrevButton == null) {
            this.finishPrevButton = new JButton();
            this.finishPrevButton.setText("Previous");
            this.finishPrevButton.setEnabled(false);
            this.finishPrevButton.setBounds(200, this.getFrameHeight() - 100, 100, 30);
        }
        return this.finishPrevButton;
    }

    private JButton getFinishNextButton() {
        if (this.finishNextButton == null) {
            this.finishNextButton = new JButton();
            this.finishNextButton.setText("Finish");
            this.finishNextButton.setBounds(this.getFrameWidth() - 350, this.getFrameHeight() - 100, 100, 30);
            this.finishNextButton.addActionListener(new FinishNextListener());
        }
        return this.finishNextButton;
    }

    private JLabel getFinishSuccessLabel() {
        if (this.finishSuccessLabel == null) {
            this.finishSuccessLabel = new JLabel();
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h2>The installation was successful. The log is in " + this.installerLog + "</h2><br/><h3>You can run XSB using:</h3><h3>&nbsp;&nbsp;" + this.currentDir + "bin/xsb</h3><br/><br/><h3>Click <i>Finish</i> to exit.</h3></body></html>";
            this.finishSuccessLabel.setText(message);
            this.finishSuccessLabel.setBounds(30, 20, 670, 400);
        }
        return this.finishSuccessLabel;
    }

    private JLabel getFinishFailLabel() {
        if (this.finishFailLabel == null) {
            this.finishFailLabel = new JLabel();
            String message = "<html><body><h1>XSB Installation</h1><br/><br/><h2>The installation was not successful.</h2><br/><h2>Please check " + this.installerLog + " for errors.</h2><br/><br/><h2>Click <i>Finish</i> to exit.</h2></body></html>";
            this.finishFailLabel.setText(message);
            this.finishFailLabel.setBounds(30, 20, 600, 400);
        }
        return this.finishFailLabel;
    }

    public void installation() {
        Thread t = new Thread(){
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    LinuxFrame.this.getInstallTextArea().setText(LinuxFrame.this.readline);
                    JScrollBar sbar = LinuxFrame.this.getInstallScrollPane().getVerticalScrollBar();
                    sbar.setValue(sbar.getMaximum());
                }
            };

            @Override
            public void run() {
                String command = "sh " + LinuxFrame.this.installerShell;
                String command1 = command + LinuxFrame.this.osType.toLowerCase() + " installFeatures <your password>";
                command = command + LinuxFrame.this.osType.toLowerCase() + " installFeatures " + LinuxFrame.this.password;
                System.out.println(command1);
                if (LinuxFrame.this.features[0] == 1) {
                    command = command + " db";
                }
                if (LinuxFrame.this.features[1] == 1) {
                    command = command + " http";
                }
                if (LinuxFrame.this.features[2] == 1) {
                    command = command + " xml";
                }
                if (LinuxFrame.this.features[3] == 1) {
                    command = command + " reg";
                }
                try {
                    block8: {
                        Process process = Runtime.getRuntime().exec(command);
                        Scanner s = new Scanner(process.getInputStream());
                        while (s.hasNextLine()) {
                            String nextLine = s.nextLine();
                            if (!nextLine.contains("=== done ===")) {
                                LinuxFrame.this.readline = LinuxFrame.this.readline + nextLine + "\n";
                                SwingUtilities.invokeLater(this.run);
                                continue;
                            }
                            break block8;
                        }
                        JOptionPane.showMessageDialog(LinuxFrame.this, "Something wrong during package installation: no output from shell");
                        LinuxFrame.this.getInstallNextButton().setEnabled(true);
                        return;
                    }
                    JOptionPane.showMessageDialog(LinuxFrame.this, "The required packages have been installed. Click Next to compile.");
                    LinuxFrame.this.getInstallNextButton().setEnabled(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void compilation() {
        this.readline = "";
        Thread t = new Thread(){
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    LinuxFrame.this.getCompileTextArea().setText(LinuxFrame.this.readline);
                    JScrollBar sbar = LinuxFrame.this.getCompileScrollPane().getVerticalScrollBar();
                    sbar.setValue(sbar.getMaximum());
                }
            };

            @Override
            public void run() {
                String command = "sh " + LinuxFrame.this.installerShell + LinuxFrame.this.osType.toLowerCase() + " ";
                command = LinuxFrame.this.features[0] == 1 ? command + "configure2" : command + "configure1";
                if (LinuxFrame.this.needJavaHome == 1) {
                    command = command + " " + LinuxFrame.this.homePath;
                }
                try {
                    File file;
                    block11: {
                        Process process = Runtime.getRuntime().exec(command);
                        Scanner s = new Scanner(process.getInputStream());
                        while (s.hasNextLine()) {
                            String nextLine = s.nextLine();
                            if (nextLine.contains("=== done ===")) {
                                Process resultProcess = Runtime.getRuntime().exec("sh " + LinuxFrame.this.currentDir + "bin/xsb -v");
                                try {
                                    resultProcess.waitFor();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                if (resultProcess.exitValue() == 1) {
                                    LinuxFrame.this.installSuccess = 0;
                                } else {
                                    LinuxFrame.this.installSuccess = 1;
                                }
                                break block11;
                            }
                            LinuxFrame.this.readline = LinuxFrame.this.readline + nextLine + "\n\r";
                            SwingUtilities.invokeLater(this.run);
                        }
                        JOptionPane.showMessageDialog(LinuxFrame.this, "Something wrong during compilation: no output from shell");
                        LinuxFrame.this.getCompileNextButton().setEnabled(true);
                        file = new File(LinuxFrame.this.installerLog);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        FileOutputStream fw = new FileOutputStream(file);
                        fw.write(LinuxFrame.this.readline.getBytes());
                        fw.flush();
                        fw.close();
                        return;
                    }
                    JOptionPane.showMessageDialog(LinuxFrame.this, "Compilation is complete. Click OK then Next.");
                    LinuxFrame.this.getCompileNextButton().setEnabled(true);
                    file = new File(LinuxFrame.this.installerLog);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fw = new FileOutputStream(file);
                    fw.write(LinuxFrame.this.readline.getBytes());
                    fw.flush();
                    fw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    class FinishNextListener
    implements ActionListener {
        FinishNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            System.exit(0);
        }
    }

    class CompileNextListener
    implements ActionListener {
        CompileNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LinuxFrame.this.setContentPane(LinuxFrame.this.getFinishContentPane());
            LinuxFrame.this.validate();
        }
    }

    class InstallNextListener
    implements ActionListener {
        InstallNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LinuxFrame.this.setContentPane(LinuxFrame.this.getCompileContentPane());
            LinuxFrame.this.validate();
        }
    }

    class JdkPathChooseListener
    implements ActionListener {
        JdkPathChooseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            File f = null;
            int flag = fc.showOpenDialog(null);
            if (flag == 0) {
                f = fc.getSelectedFile();
                LinuxFrame.this.homePath = f.getPath();
            }
            try {
                String command = "sh " + LinuxFrame.this.installerShell + LinuxFrame.this.osType.toLowerCase() + " checkhomearg " + LinuxFrame.this.homePath;
                Process process = Runtime.getRuntime().exec(command);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String resultStr = bufferedReader.readLine();
                if (resultStr.contains("no")) {
                    JOptionPane.showMessageDialog(LinuxFrame.this, "Invalid JDK folder. No javac or jni.h found.");
                    LinuxFrame.this.homePath = null;
                    return;
                }
                LinuxFrame.this.getJdkPathTextField().setText(LinuxFrame.this.homePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class JdkPathNextListener
    implements ActionListener {
        JdkPathNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LinuxFrame.this.setContentPane(LinuxFrame.this.getInstallContentPane());
            LinuxFrame.this.validate();
        }
    }

    class JdkPathPrevListener
    implements ActionListener {
        JdkPathPrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LinuxFrame.this.setContentPane(LinuxFrame.this.getFeatureContentPane());
            LinuxFrame.this.validate();
        }
    }

    class FeatureNextListener
    implements ActionListener {
        FeatureNextListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent arg0) {
            BufferedReader bufferedReader;
            Process process;
            String command;
            block17: {
                block18: {
                    block16: {
                        if (!(LinuxFrame.this.dbCheckBox.isSelected() || LinuxFrame.this.httpCheckBox.isSelected() || LinuxFrame.this.xmlCheckBox.isSelected() || LinuxFrame.this.regCheckBox.isSelected() || LinuxFrame.this.javaCheckBox.isSelected())) {
                            LinuxFrame.this.setContentPane(LinuxFrame.this.getCompileContentPane());
                            LinuxFrame.this.validate();
                            return;
                        }
                        String message = "To install the necessary packaged, please enter your user password:";
                        JPasswordField inputPassword = new JPasswordField();
                        Object[] ob = new Object[]{message, inputPassword};
                        int result = JOptionPane.showConfirmDialog(LinuxFrame.this, ob, "Password", 2);
                        if (result != 0 || ((JTextComponent)inputPassword).getText() == null || ((JTextComponent)inputPassword).getText().equals("")) break block16;
                        try {
                            String command2 = "sh " + LinuxFrame.this.installerShell + LinuxFrame.this.osType.toLowerCase() + " checkpassword " + ((JTextComponent)inputPassword).getText();
                            Process process2 = Runtime.getRuntime().exec(command2);
                            BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process2.getInputStream()));
                            String resultStr = bufferedReader2.readLine();
                            if (!resultStr.contains("granted")) {
                                JOptionPane.showMessageDialog(LinuxFrame.this, "Invalid password");
                                return;
                            }
                            LinuxFrame.this.password = ((JTextComponent)inputPassword).getText();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        if (!LinuxFrame.this.javaCheckBox.isSelected()) break block17;
                        break block18;
                    }
                    JOptionPane.showMessageDialog(LinuxFrame.this, "Invalid password");
                    return;
                }
                try {
                    command = "sh " + LinuxFrame.this.installerShell + LinuxFrame.this.osType.toLowerCase() + " checkJava";
                    process = Runtime.getRuntime().exec(command);
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String resultStr = bufferedReader.readLine();
                    if (resultStr.contains("no")) {
                        JOptionPane.showMessageDialog(LinuxFrame.this, "For faster XSB-Java interface you must install the Java JDK.");
                        return;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (LinuxFrame.this.dbCheckBox.isSelected()) {
                ((LinuxFrame)LinuxFrame.this).features[0] = 1;
            }
            if (LinuxFrame.this.httpCheckBox.isSelected()) {
                ((LinuxFrame)LinuxFrame.this).features[1] = 1;
            }
            if (LinuxFrame.this.xmlCheckBox.isSelected()) {
                ((LinuxFrame)LinuxFrame.this).features[2] = 1;
            }
            if (LinuxFrame.this.regCheckBox.isSelected()) {
                ((LinuxFrame)LinuxFrame.this).features[3] = 1;
            }
            if (LinuxFrame.this.javaCheckBox.isSelected()) {
                ((LinuxFrame)LinuxFrame.this).features[4] = 1;
                LinuxFrame.this.needJavaHome = 1;
                try {
                    command = "sh " + LinuxFrame.this.installerShell + LinuxFrame.this.osType.toLowerCase() + " checkhome";
                    process = Runtime.getRuntime().exec(command);
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String resultStr = bufferedReader.readLine();
                    System.out.println(resultStr);
                    if (resultStr.contains("yes")) {
                        LinuxFrame.this.needJavaHome = 0;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (LinuxFrame.this.needJavaHome == 1) {
                LinuxFrame.this.setContentPane(LinuxFrame.this.getJdkPathContentPane());
                LinuxFrame.this.validate();
                return;
            }
            LinuxFrame.this.setContentPane(LinuxFrame.this.getInstallContentPane());
            LinuxFrame.this.validate();
        }
    }

    class FeaturePrevListener
    implements ActionListener {
        FeaturePrevListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LinuxFrame.this.setContentPane(LinuxFrame.this.getInfoContentPane());
            LinuxFrame.this.validate();
        }
    }

    class InfoNextListener
    implements ActionListener {
        InfoNextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LinuxFrame.this.setContentPane(LinuxFrame.this.getFeatureContentPane());
            LinuxFrame.this.validate();
        }
    }
}

