/* File:      pairlist.P
** Author(s): Tom Schrijvers
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 1986, 1993-1998
** 
** XSB is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XSB is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XSB; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: pairlist.P,v 1.6 2010-08-19 15:03:38 spyrosh Exp $
** 
*/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%              _      _ _     _   
%%  _ __   __ _(_)_ __| (_)___| |_ 
%% | '_ \ / _` | | '__| | / __| __|
%% | |_) | (_| | | |  | | \__ \ |_ 
%% | .__/ \__,_|_|_|  |_|_|___/\__|
%% |_|                            
%%
%% * author: Tom Schrijvers, K.U.Leuven
%%
%% * written for hProlog
%%
%% * ported to XSB

:- export 
		delete/3,
		delete_all/3,
		delete_eq/3,
		delete_all_eq/3,
		lookup/3,
		lookup_any/3,
		lookup_eq/3,
		lookup_any_eq/3,
		pairup/3,
		translate/3.

pairup([],[],[]).
pairup([X|Xs],[Y|Ys],[X-Y|XYs]) :-
	pairup(Xs,Ys,XYs).

lookup([K - V | KVs],Key,Value) :-
	( K = Key ->
		V = Value
	;
		lookup(KVs,Key,Value)
	).

lookup_any([K - V | KVs],Key,Value) :-
	( 
		K = Key,
		V = Value
	;
		lookup_any(KVs,Key,Value)
	).

lookup_eq([K - V | KVs],Key,Value) :-
	( K == Key ->
		V = Value
	;
		lookup_eq(KVs,Key,Value)
	).

lookup_any_eq([K - V | KVs],Key,Value) :-
	( 
		K == Key,
		V = Value
	;
		lookup_any_eq(KVs,Key,Value)
	).

translate([],_,[]).
translate([X|Xs],Dict,[Y|Ys]) :-
	lookup_eq(Dict,X,Y),
	translate(Xs,Dict,Ys).

delete([], _, []).
delete([K - V| KVs], Key, PL) :-
	( Key = K ->
		PL = KVs
	;
		PL = [ K - V | T ],
		delete(KVs, Key, T)
	).

delete_all([], _, []).
delete_all([K - V| KVs], Key, PL) :-
	( Key = K ->
		delete_all(KVs, Key, PL)
		
	;
		PL = [ K - V | T ],
		delete_all(KVs, Key, T)
	).

delete_eq([], _, []).
delete_eq([K - V| KVs], Key, PL) :-
	( Key == K ->
		PL = KVs
	;
		PL = [ K - V | T ],
		delete_eq(KVs, Key, T)
	).

delete_all_eq([], _, []).
delete_all_eq([K - V| KVs], Key, PL) :-
	( Key == K ->
		delete_all_eq(KVs, Key, PL)
	;
		PL = [ K - V | T ],
		delete_all_eq(KVs, Key, T)
	).
		
