/* File:      trans.P	-- varieties of trans relation
** Author(s): Yifei Dong
** Contact:   lmc@cs.sunysb.edu
** 
** Copyright (C) SUNY at Stony Brook, 1998-2000
** 
** XMC is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XMC is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XMC; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: trans.P,v 1.4 2010-08-19 15:03:39 spyrosh Exp $
** 
*/

/**
    Auxiliary trans relations:
        trans(S, A, T): there is a transition A from S to T
           this relation is defined in calculus.P
   
        trans_not_a(S, A, T): there is a non A transition from S to T.
   
        trans_member(S, L, T): there is a transition A from S to T such that
   					A is in the set L.
   
        trans_not_member(S, L, T): there is a transition A from S to T 
   					such that A is not in the set L.
***/

trans_not_a(State_s, Act_a, State_t) :-
	trans(State_s, Act_b, State_t),
	\+ (Act_b == Act_a).

trans_member(State_s, Set_a, State_t) :-
        trans(State_s, Act_b, State_t),
        member(Act_b, Set_a).

trans_not_member(State_s, Set_a, State_t) :-
	trans(State_s, Act_b, State_t),
	\+ member(Act_b, Set_a).
