/* File:      debugger_data.P
** Author(s): David S. Warren, kifer
** Contact:   xsb-contact@cs.sunysb.edu
** 
** Copyright (C) The Research Foundation of SUNY, 1993-1999
** 
** XSB is free software; you can redistribute it and/or modify it under the
** terms of the GNU Library General Public License as published by the Free
** Software Foundation; either version 2 of the License, or (at your option)
** any later version.
** 
** XSB is distributed in the hope that it will be useful, but WITHOUT ANY
** WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
** FOR A PARTICULAR PURPOSE.  See the GNU Library General Public License for
** more details.
** 
** You should have received a copy of the GNU Library General Public License
** along with XSB; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
** $Id: debugger_data.P,v 1.13 2008/08/25 19:18:04 dwarren Exp $
** 
*/

/* 
** The user can define these things:
**    hide_this_show(Pred,Arity): calls to hide, but show embedded calls
**    hide_this_hide(Pred,Arity): calls to hide along with embedded code
**    show_this_hide(Pred,Arity): calls to show, but hide embedded ones
**
**    trace_standard_predicate(Pred,Arity): normally trace doesn't go inside
**    	      	      	      	      	    standard preds, ulsess this is set
**    trace_this_print(P,A):      turn on trace user prompt and keep tracing
**    trace_this_noprint(P,A):    turn off trace user prompt but keep tracing;
**    	      	      	      	  the prompt for P is not displayed
**
**    trace_this_enable_print_on_redo(P,A): these predicates turn on trace
**    	      	      	      	      	    prompt on "Redo". We already must
**    	      	      	      	      	    be tracing with interrupts enabled.
**    
**
** The user must assert these facts in usermod.
*/


% hide only this call, trace embedded calls
hide_this_show(call_expose,1).
hide_this_show(':',2).
hide_this_show(',',2).
hide_this_show(';',2).
hide_this_show('->',2).

% hide this call and all embedded calls
hide_this_hide('_$call',1).
hide_this_hide(trace,0).
hide_this_hide(debug_ctl,2).
hide_this_hide(notrace,0).
hide_this_hide(debug,0).
hide_this_hide(nodebug,0).
hide_this_hide(halt,0).
hide_this_hide(debugging,0).
hide_this_hide(spy,1).
hide_this_hide(nospy,1).
hide_this_hide(consult,1).
hide_this_hide(reconsult,1).
hide_this_hide(compile,1).
hide_this_hide(call_goal_cut_trans,3).

hide_this_hide(compile_internal,5).
hide_this_hide(make_gpp_command,4).

hide_this_hide(abolish_table_pred,1).
hide_this_hide(abolish_table_call,1).
hide_this_hide(abolish_all_tables,0).

show_this_hide(incr_assert,1).
show_this_hide(incr_asserta,1).
show_this_hide(incr_assertz,1).
show_this_hide(incr_retract,1).
show_this_hide(incr_retractall,1).
show_this_hide(incr_directly_depends,2).
show_this_hide(incr_trans_depends,2).
show_this_hide(is_incremental_subgoal,1).
show_this_hide(incr_is_invalid,1).

%% trace inside these standard predicates
trace_standard_predicate(call,1).
trace_standard_predicate(call,2).
trace_standard_predicate(call,3).
trace_standard_predicate(call,4).
trace_standard_predicate(call,5).
trace_standard_predicate(call,6).
trace_standard_predicate(call,7).
trace_standard_predicate(call,8).
trace_standard_predicate(call,9).
trace_standard_predicate(call,10).
%% but control debugger prompts that are actually printed
%% trace inside call_c and print debugger prompts (but not call_c itself)
trace_this_print(call_c, 1).
%% trace inside call and goal_cut_trans, but don't print anything
trace_this_noprint(call, 1).
trace_this_noprint(goal_cut_trans, 3).

%% Trace this standard predicate
trace_standard_predicate(findall,3).
%% but control the prompts that are actualy printed
trace_this_noprint(bfindall, 4). %% this is an auxiliary pred for findall

trace_standard_predicate(setof,3).
trace_standard_predicate(bagof,3).
trace_this_noprint(bagof1, 3).

%% Trace this standard predicate
trace_standard_predicate(once,1).
trace_standard_predicate((\+),1).

trace_standard_predicate((tnot),1).
hide_this_hide(table_inspection_function,7).
hide_this_show(t_not_variant,4).
hide_this_show(tcall,1).
hide_this_hide(is_incomplete,2).

trace_standard_predicate(catch,3).
trace_this_print(catch,3).
trace_this_noprint('$$exception_ball',2).

%% On Redo, enable printing of debug prompts
trace_this_enable_print_on_redo(call, 1).

% call_c is eliminated, so what is called is traced.
is_xpar_call(call_c, 1).

trace_standard_predicate(phrase,2).
trace_this_noprint(dcg_body_nonvar,4).
trace_this_noprint(reset_dcg_mode,0).
trace_standard_predicate(phrase,3).

trace_standard_predicate(tphrase,3).
trace_this_noprint(num_words,1).
trace_standard_predicate(tphrase,2).

'_$_debugger_data_loaded'.

trace_standard_predicate(assert,1).