/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.internal.logging.progress.ProgressLogger;

public class DefaultCleanupProgressMonitor
implements CleanupProgressMonitor {
    private final ProgressLogger progressLogger;
    private long deleted;
    private long skipped;

    public DefaultCleanupProgressMonitor(ProgressLogger progressLogger) {
        this.progressLogger = progressLogger;
    }

    @Override
    public void incrementDeleted() {
        ++this.deleted;
        this.updateProgress();
    }

    @Override
    public void incrementSkipped() {
        this.incrementSkipped(1L);
    }

    @Override
    public void incrementSkipped(long amount) {
        this.skipped += amount;
        this.updateProgress();
    }

    private void updateProgress() {
        this.progressLogger.progress(this.progressLogger.getDescription() + ": " + this.mandatoryNumber(this.deleted, " entry", " entries") + " deleted" + this.optionalNumber(", ", this.skipped, " skipped"));
    }

    private String mandatoryNumber(long value, String singular, String plural) {
        return value == 1L ? value + singular : value + plural;
    }

    private String optionalNumber(String separator, long value, String description) {
        return value == 0L ? "" : separator + value + description;
    }
}

