// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/monitoring/dashboard/v1/common.proto

package dashboard

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The `Aligner` specifies the operation that will be applied to the data
// points in each alignment period in a time series. Except for
// `ALIGN_NONE`, which specifies that no operation be applied, each alignment
// operation replaces the set of data values in each alignment period with
// a single value: the result of applying the operation to the data values.
// An aligned time series has a single data value at the end of each
// `alignment_period`.
//
// An alignment operation can change the data type of the values, too. For
// example, if you apply a counting operation to boolean values, the data
// `value_type` in the original time series is `BOOLEAN`, but the `value_type`
// in the aligned result is `INT64`.
type Aggregation_Aligner int32

const (
	// No alignment. Raw data is returned. Not valid if cross-series reduction
	// is requested. The `value_type` of the result is the same as the
	// `value_type` of the input.
	Aggregation_ALIGN_NONE Aggregation_Aligner = 0
	// Align and convert to
	// [DELTA][google.api.MetricDescriptor.MetricKind.DELTA].
	// The output is `delta = y1 - y0`.
	//
	// This alignment is valid for
	// [CUMULATIVE][google.api.MetricDescriptor.MetricKind.CUMULATIVE] and
	// `DELTA` metrics. If the selected alignment period results in periods
	// with no data, then the aligned value for such a period is created by
	// interpolation. The `value_type`  of the aligned result is the same as
	// the `value_type` of the input.
	Aggregation_ALIGN_DELTA Aggregation_Aligner = 1
	// Align and convert to a rate. The result is computed as
	// `rate = (y1 - y0)/(t1 - t0)`, or "delta over time".
	// Think of this aligner as providing the slope of the line that passes
	// through the value at the start and at the end of the `alignment_period`.
	//
	// This aligner is valid for `CUMULATIVE`
	// and `DELTA` metrics with numeric values. If the selected alignment
	// period results in periods with no data, then the aligned value for
	// such a period is created by interpolation. The output is a `GAUGE`
	// metric with `value_type` `DOUBLE`.
	//
	// If, by "rate", you mean "percentage change", see the
	// `ALIGN_PERCENT_CHANGE` aligner instead.
	Aggregation_ALIGN_RATE Aggregation_Aligner = 2
	// Align by interpolating between adjacent points around the alignment
	// period boundary. This aligner is valid for `GAUGE` metrics with
	// numeric values. The `value_type` of the aligned result is the same as the
	// `value_type` of the input.
	Aggregation_ALIGN_INTERPOLATE Aggregation_Aligner = 3
	// Align by moving the most recent data point before the end of the
	// alignment period to the boundary at the end of the alignment
	// period. This aligner is valid for `GAUGE` metrics. The `value_type` of
	// the aligned result is the same as the `value_type` of the input.
	Aggregation_ALIGN_NEXT_OLDER Aggregation_Aligner = 4
	// Align the time series by returning the minimum value in each alignment
	// period. This aligner is valid for `GAUGE` and `DELTA` metrics with
	// numeric values. The `value_type` of the aligned result is the same as
	// the `value_type` of the input.
	Aggregation_ALIGN_MIN Aggregation_Aligner = 10
	// Align the time series by returning the maximum value in each alignment
	// period. This aligner is valid for `GAUGE` and `DELTA` metrics with
	// numeric values. The `value_type` of the aligned result is the same as
	// the `value_type` of the input.
	Aggregation_ALIGN_MAX Aggregation_Aligner = 11
	// Align the time series by returning the mean value in each alignment
	// period. This aligner is valid for `GAUGE` and `DELTA` metrics with
	// numeric values. The `value_type` of the aligned result is `DOUBLE`.
	Aggregation_ALIGN_MEAN Aggregation_Aligner = 12
	// Align the time series by returning the number of values in each alignment
	// period. This aligner is valid for `GAUGE` and `DELTA` metrics with
	// numeric or Boolean values. The `value_type` of the aligned result is
	// `INT64`.
	Aggregation_ALIGN_COUNT Aggregation_Aligner = 13
	// Align the time series by returning the sum of the values in each
	// alignment period. This aligner is valid for `GAUGE` and `DELTA`
	// metrics with numeric and distribution values. The `value_type` of the
	// aligned result is the same as the `value_type` of the input.
	Aggregation_ALIGN_SUM Aggregation_Aligner = 14
	// Align the time series by returning the standard deviation of the values
	// in each alignment period. This aligner is valid for `GAUGE` and
	// `DELTA` metrics with numeric values. The `value_type` of the output is
	// `DOUBLE`.
	Aggregation_ALIGN_STDDEV Aggregation_Aligner = 15
	// Align the time series by returning the number of `True` values in
	// each alignment period. This aligner is valid for `GAUGE` metrics with
	// Boolean values. The `value_type` of the output is `INT64`.
	Aggregation_ALIGN_COUNT_TRUE Aggregation_Aligner = 16
	// Align the time series by returning the number of `False` values in
	// each alignment period. This aligner is valid for `GAUGE` metrics with
	// Boolean values. The `value_type` of the output is `INT64`.
	Aggregation_ALIGN_COUNT_FALSE Aggregation_Aligner = 24
	// Align the time series by returning the ratio of the number of `True`
	// values to the total number of values in each alignment period. This
	// aligner is valid for `GAUGE` metrics with Boolean values. The output
	// value is in the range [0.0, 1.0] and has `value_type` `DOUBLE`.
	Aggregation_ALIGN_FRACTION_TRUE Aggregation_Aligner = 17
	// Align the time series by using [percentile
	// aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
	// data point in each alignment period is the 99th percentile of all data
	// points in the period. This aligner is valid for `GAUGE` and `DELTA`
	// metrics with distribution values. The output is a `GAUGE` metric with
	// `value_type` `DOUBLE`.
	Aggregation_ALIGN_PERCENTILE_99 Aggregation_Aligner = 18
	// Align the time series by using [percentile
	// aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
	// data point in each alignment period is the 95th percentile of all data
	// points in the period. This aligner is valid for `GAUGE` and `DELTA`
	// metrics with distribution values. The output is a `GAUGE` metric with
	// `value_type` `DOUBLE`.
	Aggregation_ALIGN_PERCENTILE_95 Aggregation_Aligner = 19
	// Align the time series by using [percentile
	// aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
	// data point in each alignment period is the 50th percentile of all data
	// points in the period. This aligner is valid for `GAUGE` and `DELTA`
	// metrics with distribution values. The output is a `GAUGE` metric with
	// `value_type` `DOUBLE`.
	Aggregation_ALIGN_PERCENTILE_50 Aggregation_Aligner = 20
	// Align the time series by using [percentile
	// aggregation](https://en.wikipedia.org/wiki/Percentile). The resulting
	// data point in each alignment period is the 5th percentile of all data
	// points in the period. This aligner is valid for `GAUGE` and `DELTA`
	// metrics with distribution values. The output is a `GAUGE` metric with
	// `value_type` `DOUBLE`.
	Aggregation_ALIGN_PERCENTILE_05 Aggregation_Aligner = 21
	// Align and convert to a percentage change. This aligner is valid for
	// `GAUGE` and `DELTA` metrics with numeric values. This alignment returns
	// `((current - previous)/previous) * 100`, where the value of `previous` is
	// determined based on the `alignment_period`.
	//
	// If the values of `current` and `previous` are both 0, then the returned
	// value is 0. If only `previous` is 0, the returned value is infinity.
	//
	// A 10-minute moving mean is computed at each point of the alignment period
	// prior to the above calculation to smooth the metric and prevent false
	// positives from very short-lived spikes. The moving mean is only
	// applicable for data whose values are `>= 0`. Any values `< 0` are
	// treated as a missing datapoint, and are ignored. While `DELTA`
	// metrics are accepted by this alignment, special care should be taken that
	// the values for the metric will always be positive. The output is a
	// `GAUGE` metric with `value_type` `DOUBLE`.
	Aggregation_ALIGN_PERCENT_CHANGE Aggregation_Aligner = 23
)

// Enum value maps for Aggregation_Aligner.
var (
	Aggregation_Aligner_name = map[int32]string{
		0:  "ALIGN_NONE",
		1:  "ALIGN_DELTA",
		2:  "ALIGN_RATE",
		3:  "ALIGN_INTERPOLATE",
		4:  "ALIGN_NEXT_OLDER",
		10: "ALIGN_MIN",
		11: "ALIGN_MAX",
		12: "ALIGN_MEAN",
		13: "ALIGN_COUNT",
		14: "ALIGN_SUM",
		15: "ALIGN_STDDEV",
		16: "ALIGN_COUNT_TRUE",
		24: "ALIGN_COUNT_FALSE",
		17: "ALIGN_FRACTION_TRUE",
		18: "ALIGN_PERCENTILE_99",
		19: "ALIGN_PERCENTILE_95",
		20: "ALIGN_PERCENTILE_50",
		21: "ALIGN_PERCENTILE_05",
		23: "ALIGN_PERCENT_CHANGE",
	}
	Aggregation_Aligner_value = map[string]int32{
		"ALIGN_NONE":           0,
		"ALIGN_DELTA":          1,
		"ALIGN_RATE":           2,
		"ALIGN_INTERPOLATE":    3,
		"ALIGN_NEXT_OLDER":     4,
		"ALIGN_MIN":            10,
		"ALIGN_MAX":            11,
		"ALIGN_MEAN":           12,
		"ALIGN_COUNT":          13,
		"ALIGN_SUM":            14,
		"ALIGN_STDDEV":         15,
		"ALIGN_COUNT_TRUE":     16,
		"ALIGN_COUNT_FALSE":    24,
		"ALIGN_FRACTION_TRUE":  17,
		"ALIGN_PERCENTILE_99":  18,
		"ALIGN_PERCENTILE_95":  19,
		"ALIGN_PERCENTILE_50":  20,
		"ALIGN_PERCENTILE_05":  21,
		"ALIGN_PERCENT_CHANGE": 23,
	}
)

func (x Aggregation_Aligner) Enum() *Aggregation_Aligner {
	p := new(Aggregation_Aligner)
	*p = x
	return p
}

func (x Aggregation_Aligner) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Aggregation_Aligner) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_common_proto_enumTypes[0].Descriptor()
}

func (Aggregation_Aligner) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_common_proto_enumTypes[0]
}

func (x Aggregation_Aligner) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Aggregation_Aligner.Descriptor instead.
func (Aggregation_Aligner) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_common_proto_rawDescGZIP(), []int{0, 0}
}

// A Reducer operation describes how to aggregate data points from multiple
// time series into a single time series, where the value of each data point
// in the resulting series is a function of all the already aligned values in
// the input time series.
type Aggregation_Reducer int32

const (
	// No cross-time series reduction. The output of the `Aligner` is
	// returned.
	Aggregation_REDUCE_NONE Aggregation_Reducer = 0
	// Reduce by computing the mean value across time series for each
	// alignment period. This reducer is valid for
	// [DELTA][google.api.MetricDescriptor.MetricKind.DELTA] and
	// [GAUGE][google.api.MetricDescriptor.MetricKind.GAUGE] metrics with
	// numeric or distribution values. The `value_type` of the output is
	// [DOUBLE][google.api.MetricDescriptor.ValueType.DOUBLE].
	Aggregation_REDUCE_MEAN Aggregation_Reducer = 1
	// Reduce by computing the minimum value across time series for each
	// alignment period. This reducer is valid for `DELTA` and `GAUGE` metrics
	// with numeric values. The `value_type` of the output is the same as the
	// `value_type` of the input.
	Aggregation_REDUCE_MIN Aggregation_Reducer = 2
	// Reduce by computing the maximum value across time series for each
	// alignment period. This reducer is valid for `DELTA` and `GAUGE` metrics
	// with numeric values. The `value_type` of the output is the same as the
	// `value_type` of the input.
	Aggregation_REDUCE_MAX Aggregation_Reducer = 3
	// Reduce by computing the sum across time series for each
	// alignment period. This reducer is valid for `DELTA` and `GAUGE` metrics
	// with numeric and distribution values. The `value_type` of the output is
	// the same as the `value_type` of the input.
	Aggregation_REDUCE_SUM Aggregation_Reducer = 4
	// Reduce by computing the standard deviation across time series
	// for each alignment period. This reducer is valid for `DELTA` and
	// `GAUGE` metrics with numeric or distribution values. The `value_type`
	// of the output is `DOUBLE`.
	Aggregation_REDUCE_STDDEV Aggregation_Reducer = 5
	// Reduce by computing the number of data points across time series
	// for each alignment period. This reducer is valid for `DELTA` and
	// `GAUGE` metrics of numeric, Boolean, distribution, and string
	// `value_type`. The `value_type` of the output is `INT64`.
	Aggregation_REDUCE_COUNT Aggregation_Reducer = 6
	// Reduce by computing the number of `True`-valued data points across time
	// series for each alignment period. This reducer is valid for `DELTA` and
	// `GAUGE` metrics of Boolean `value_type`. The `value_type` of the output
	// is `INT64`.
	Aggregation_REDUCE_COUNT_TRUE Aggregation_Reducer = 7
	// Reduce by computing the number of `False`-valued data points across time
	// series for each alignment period. This reducer is valid for `DELTA` and
	// `GAUGE` metrics of Boolean `value_type`. The `value_type` of the output
	// is `INT64`.
	Aggregation_REDUCE_COUNT_FALSE Aggregation_Reducer = 15
	// Reduce by computing the ratio of the number of `True`-valued data points
	// to the total number of data points for each alignment period. This
	// reducer is valid for `DELTA` and `GAUGE` metrics of Boolean `value_type`.
	// The output value is in the range [0.0, 1.0] and has `value_type`
	// `DOUBLE`.
	Aggregation_REDUCE_FRACTION_TRUE Aggregation_Reducer = 8
	// Reduce by computing the [99th
	// percentile](https://en.wikipedia.org/wiki/Percentile) of data points
	// across time series for each alignment period. This reducer is valid for
	// `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
	// of the output is `DOUBLE`.
	Aggregation_REDUCE_PERCENTILE_99 Aggregation_Reducer = 9
	// Reduce by computing the [95th
	// percentile](https://en.wikipedia.org/wiki/Percentile) of data points
	// across time series for each alignment period. This reducer is valid for
	// `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
	// of the output is `DOUBLE`.
	Aggregation_REDUCE_PERCENTILE_95 Aggregation_Reducer = 10
	// Reduce by computing the [50th
	// percentile](https://en.wikipedia.org/wiki/Percentile) of data points
	// across time series for each alignment period. This reducer is valid for
	// `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
	// of the output is `DOUBLE`.
	Aggregation_REDUCE_PERCENTILE_50 Aggregation_Reducer = 11
	// Reduce by computing the [5th
	// percentile](https://en.wikipedia.org/wiki/Percentile) of data points
	// across time series for each alignment period. This reducer is valid for
	// `GAUGE` and `DELTA` metrics of numeric and distribution type. The value
	// of the output is `DOUBLE`.
	Aggregation_REDUCE_PERCENTILE_05 Aggregation_Reducer = 12
)

// Enum value maps for Aggregation_Reducer.
var (
	Aggregation_Reducer_name = map[int32]string{
		0:  "REDUCE_NONE",
		1:  "REDUCE_MEAN",
		2:  "REDUCE_MIN",
		3:  "REDUCE_MAX",
		4:  "REDUCE_SUM",
		5:  "REDUCE_STDDEV",
		6:  "REDUCE_COUNT",
		7:  "REDUCE_COUNT_TRUE",
		15: "REDUCE_COUNT_FALSE",
		8:  "REDUCE_FRACTION_TRUE",
		9:  "REDUCE_PERCENTILE_99",
		10: "REDUCE_PERCENTILE_95",
		11: "REDUCE_PERCENTILE_50",
		12: "REDUCE_PERCENTILE_05",
	}
	Aggregation_Reducer_value = map[string]int32{
		"REDUCE_NONE":          0,
		"REDUCE_MEAN":          1,
		"REDUCE_MIN":           2,
		"REDUCE_MAX":           3,
		"REDUCE_SUM":           4,
		"REDUCE_STDDEV":        5,
		"REDUCE_COUNT":         6,
		"REDUCE_COUNT_TRUE":    7,
		"REDUCE_COUNT_FALSE":   15,
		"REDUCE_FRACTION_TRUE": 8,
		"REDUCE_PERCENTILE_99": 9,
		"REDUCE_PERCENTILE_95": 10,
		"REDUCE_PERCENTILE_50": 11,
		"REDUCE_PERCENTILE_05": 12,
	}
)

func (x Aggregation_Reducer) Enum() *Aggregation_Reducer {
	p := new(Aggregation_Reducer)
	*p = x
	return p
}

func (x Aggregation_Reducer) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Aggregation_Reducer) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_common_proto_enumTypes[1].Descriptor()
}

func (Aggregation_Reducer) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_common_proto_enumTypes[1]
}

func (x Aggregation_Reducer) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Aggregation_Reducer.Descriptor instead.
func (Aggregation_Reducer) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_common_proto_rawDescGZIP(), []int{0, 1}
}

// The value reducers that can be applied to a `PickTimeSeriesFilter`.
type PickTimeSeriesFilter_Method int32

const (
	// Not allowed. You must specify a different `Method` if you specify a
	// `PickTimeSeriesFilter`.
	PickTimeSeriesFilter_METHOD_UNSPECIFIED PickTimeSeriesFilter_Method = 0
	// Select the mean of all values.
	PickTimeSeriesFilter_METHOD_MEAN PickTimeSeriesFilter_Method = 1
	// Select the maximum value.
	PickTimeSeriesFilter_METHOD_MAX PickTimeSeriesFilter_Method = 2
	// Select the minimum value.
	PickTimeSeriesFilter_METHOD_MIN PickTimeSeriesFilter_Method = 3
	// Compute the sum of all values.
	PickTimeSeriesFilter_METHOD_SUM PickTimeSeriesFilter_Method = 4
	// Select the most recent value.
	PickTimeSeriesFilter_METHOD_LATEST PickTimeSeriesFilter_Method = 5
)

// Enum value maps for PickTimeSeriesFilter_Method.
var (
	PickTimeSeriesFilter_Method_name = map[int32]string{
		0: "METHOD_UNSPECIFIED",
		1: "METHOD_MEAN",
		2: "METHOD_MAX",
		3: "METHOD_MIN",
		4: "METHOD_SUM",
		5: "METHOD_LATEST",
	}
	PickTimeSeriesFilter_Method_value = map[string]int32{
		"METHOD_UNSPECIFIED": 0,
		"METHOD_MEAN":        1,
		"METHOD_MAX":         2,
		"METHOD_MIN":         3,
		"METHOD_SUM":         4,
		"METHOD_LATEST":      5,
	}
)

func (x PickTimeSeriesFilter_Method) Enum() *PickTimeSeriesFilter_Method {
	p := new(PickTimeSeriesFilter_Method)
	*p = x
	return p
}

func (x PickTimeSeriesFilter_Method) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PickTimeSeriesFilter_Method) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_common_proto_enumTypes[2].Descriptor()
}

func (PickTimeSeriesFilter_Method) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_common_proto_enumTypes[2]
}

func (x PickTimeSeriesFilter_Method) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PickTimeSeriesFilter_Method.Descriptor instead.
func (PickTimeSeriesFilter_Method) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_common_proto_rawDescGZIP(), []int{1, 0}
}

// Describes the ranking directions.
type PickTimeSeriesFilter_Direction int32

const (
	// Not allowed. You must specify a different `Direction` if you specify a
	// `PickTimeSeriesFilter`.
	PickTimeSeriesFilter_DIRECTION_UNSPECIFIED PickTimeSeriesFilter_Direction = 0
	// Pass the highest `num_time_series` ranking inputs.
	PickTimeSeriesFilter_TOP PickTimeSeriesFilter_Direction = 1
	// Pass the lowest `num_time_series` ranking inputs.
	PickTimeSeriesFilter_BOTTOM PickTimeSeriesFilter_Direction = 2
)

// Enum value maps for PickTimeSeriesFilter_Direction.
var (
	PickTimeSeriesFilter_Direction_name = map[int32]string{
		0: "DIRECTION_UNSPECIFIED",
		1: "TOP",
		2: "BOTTOM",
	}
	PickTimeSeriesFilter_Direction_value = map[string]int32{
		"DIRECTION_UNSPECIFIED": 0,
		"TOP":                   1,
		"BOTTOM":                2,
	}
)

func (x PickTimeSeriesFilter_Direction) Enum() *PickTimeSeriesFilter_Direction {
	p := new(PickTimeSeriesFilter_Direction)
	*p = x
	return p
}

func (x PickTimeSeriesFilter_Direction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PickTimeSeriesFilter_Direction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_common_proto_enumTypes[3].Descriptor()
}

func (PickTimeSeriesFilter_Direction) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_common_proto_enumTypes[3]
}

func (x PickTimeSeriesFilter_Direction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PickTimeSeriesFilter_Direction.Descriptor instead.
func (PickTimeSeriesFilter_Direction) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_common_proto_rawDescGZIP(), []int{1, 1}
}

// The filter methods that can be applied to a stream.
type StatisticalTimeSeriesFilter_Method int32

const (
	// Not allowed in well-formed requests.
	StatisticalTimeSeriesFilter_METHOD_UNSPECIFIED StatisticalTimeSeriesFilter_Method = 0
	// Compute the outlier score of each stream.
	StatisticalTimeSeriesFilter_METHOD_CLUSTER_OUTLIER StatisticalTimeSeriesFilter_Method = 1
)

// Enum value maps for StatisticalTimeSeriesFilter_Method.
var (
	StatisticalTimeSeriesFilter_Method_name = map[int32]string{
		0: "METHOD_UNSPECIFIED",
		1: "METHOD_CLUSTER_OUTLIER",
	}
	StatisticalTimeSeriesFilter_Method_value = map[string]int32{
		"METHOD_UNSPECIFIED":     0,
		"METHOD_CLUSTER_OUTLIER": 1,
	}
)

func (x StatisticalTimeSeriesFilter_Method) Enum() *StatisticalTimeSeriesFilter_Method {
	p := new(StatisticalTimeSeriesFilter_Method)
	*p = x
	return p
}

func (x StatisticalTimeSeriesFilter_Method) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StatisticalTimeSeriesFilter_Method) Descriptor() protoreflect.EnumDescriptor {
	return file_google_monitoring_dashboard_v1_common_proto_enumTypes[4].Descriptor()
}

func (StatisticalTimeSeriesFilter_Method) Type() protoreflect.EnumType {
	return &file_google_monitoring_dashboard_v1_common_proto_enumTypes[4]
}

func (x StatisticalTimeSeriesFilter_Method) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StatisticalTimeSeriesFilter_Method.Descriptor instead.
func (StatisticalTimeSeriesFilter_Method) EnumDescriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_common_proto_rawDescGZIP(), []int{2, 0}
}

// Describes how to combine multiple time series to provide a different view of
// the data.  Aggregation of time series is done in two steps. First, each time
// series in the set is _aligned_ to the same time interval boundaries, then the
// set of time series is optionally _reduced_ in number.
//
// Alignment consists of applying the `per_series_aligner` operation
// to each time series after its data has been divided into regular
// `alignment_period` time intervals. This process takes _all_ of the data
// points in an alignment period, applies a mathematical transformation such as
// averaging, minimum, maximum, delta, etc., and converts them into a single
// data point per period.
//
// Reduction is when the aligned and transformed time series can optionally be
// combined, reducing the number of time series through similar mathematical
// transformations. Reduction involves applying a `cross_series_reducer` to
// all the time series, optionally sorting the time series into subsets with
// `group_by_fields`, and applying the reducer to each subset.
//
// The raw time series data can contain a huge amount of information from
// multiple sources. Alignment and reduction transforms this mass of data into
// a more manageable and representative collection of data, for example "the
// 95% latency across the average of all tasks in a cluster". This
// representative data can be more easily graphed and comprehended, and the
// individual time series data is still available for later drilldown. For more
// details, see [Filtering and
// aggregation](https://cloud.google.com/monitoring/api/v3/aggregation).
type Aggregation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `alignment_period` specifies a time interval, in seconds, that is used
	// to divide the data in all the
	// [time series][google.monitoring.v3.TimeSeries] into consistent blocks of
	// time. This will be done before the per-series aligner can be applied to
	// the data.
	//
	// The value must be at least 60 seconds. If a per-series aligner other than
	// `ALIGN_NONE` is specified, this field is required or an error is returned.
	// If no per-series aligner is specified, or the aligner `ALIGN_NONE` is
	// specified, then this field is ignored.
	//
	// The maximum value of the `alignment_period` is 2 years, or 104 weeks.
	AlignmentPeriod *durationpb.Duration `protobuf:"bytes,1,opt,name=alignment_period,json=alignmentPeriod,proto3" json:"alignment_period,omitempty"`
	// An `Aligner` describes how to bring the data points in a single
	// time series into temporal alignment. Except for `ALIGN_NONE`, all
	// alignments cause all the data points in an `alignment_period` to be
	// mathematically grouped together, resulting in a single data point for
	// each `alignment_period` with end timestamp at the end of the period.
	//
	// Not all alignment operations may be applied to all time series. The valid
	// choices depend on the `metric_kind` and `value_type` of the original time
	// series. Alignment can change the `metric_kind` or the `value_type` of
	// the time series.
	//
	// Time series data must be aligned in order to perform cross-time
	// series reduction. If `cross_series_reducer` is specified, then
	// `per_series_aligner` must be specified and not equal to `ALIGN_NONE`
	// and `alignment_period` must be specified; otherwise, an error is
	// returned.
	PerSeriesAligner Aggregation_Aligner `protobuf:"varint,2,opt,name=per_series_aligner,json=perSeriesAligner,proto3,enum=google.monitoring.dashboard.v1.Aggregation_Aligner" json:"per_series_aligner,omitempty"`
	// The reduction operation to be used to combine time series into a single
	// time series, where the value of each data point in the resulting series is
	// a function of all the already aligned values in the input time series.
	//
	// Not all reducer operations can be applied to all time series. The valid
	// choices depend on the `metric_kind` and the `value_type` of the original
	// time series. Reduction can yield a time series with a different
	// `metric_kind` or `value_type` than the input time series.
	//
	// Time series data must first be aligned (see `per_series_aligner`) in order
	// to perform cross-time series reduction. If `cross_series_reducer` is
	// specified, then `per_series_aligner` must be specified, and must not be
	// `ALIGN_NONE`. An `alignment_period` must also be specified; otherwise, an
	// error is returned.
	CrossSeriesReducer Aggregation_Reducer `protobuf:"varint,4,opt,name=cross_series_reducer,json=crossSeriesReducer,proto3,enum=google.monitoring.dashboard.v1.Aggregation_Reducer" json:"cross_series_reducer,omitempty"`
	// The set of fields to preserve when `cross_series_reducer` is
	// specified. The `group_by_fields` determine how the time series are
	// partitioned into subsets prior to applying the aggregation
	// operation. Each subset contains time series that have the same
	// value for each of the grouping fields. Each individual time
	// series is a member of exactly one subset. The
	// `cross_series_reducer` is applied to each subset of time series.
	// It is not possible to reduce across different resource types, so
	// this field implicitly contains `resource.type`.  Fields not
	// specified in `group_by_fields` are aggregated away.  If
	// `group_by_fields` is not specified and all the time series have
	// the same resource type, then the time series are aggregated into
	// a single output time series. If `cross_series_reducer` is not
	// defined, this field is ignored.
	GroupByFields []string `protobuf:"bytes,5,rep,name=group_by_fields,json=groupByFields,proto3" json:"group_by_fields,omitempty"`
}

func (x *Aggregation) Reset() {
	*x = Aggregation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_common_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Aggregation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Aggregation) ProtoMessage() {}

func (x *Aggregation) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_common_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Aggregation.ProtoReflect.Descriptor instead.
func (*Aggregation) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_common_proto_rawDescGZIP(), []int{0}
}

func (x *Aggregation) GetAlignmentPeriod() *durationpb.Duration {
	if x != nil {
		return x.AlignmentPeriod
	}
	return nil
}

func (x *Aggregation) GetPerSeriesAligner() Aggregation_Aligner {
	if x != nil {
		return x.PerSeriesAligner
	}
	return Aggregation_ALIGN_NONE
}

func (x *Aggregation) GetCrossSeriesReducer() Aggregation_Reducer {
	if x != nil {
		return x.CrossSeriesReducer
	}
	return Aggregation_REDUCE_NONE
}

func (x *Aggregation) GetGroupByFields() []string {
	if x != nil {
		return x.GroupByFields
	}
	return nil
}

// Describes a ranking-based time series filter. Each input time series is
// ranked with an aligner. The filter will allow up to `num_time_series` time
// series to pass through it, selecting them based on the relative ranking.
//
// For example, if `ranking_method` is `METHOD_MEAN`,`direction` is `BOTTOM`,
// and `num_time_series` is 3, then the 3 times series with the lowest mean
// values will pass through the filter.
type PickTimeSeriesFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `ranking_method` is applied to each time series independently to produce
	// the value which will be used to compare the time series to other time
	// series.
	RankingMethod PickTimeSeriesFilter_Method `protobuf:"varint,1,opt,name=ranking_method,json=rankingMethod,proto3,enum=google.monitoring.dashboard.v1.PickTimeSeriesFilter_Method" json:"ranking_method,omitempty"`
	// How many time series to allow to pass through the filter.
	NumTimeSeries int32 `protobuf:"varint,2,opt,name=num_time_series,json=numTimeSeries,proto3" json:"num_time_series,omitempty"`
	// How to use the ranking to select time series that pass through the filter.
	Direction PickTimeSeriesFilter_Direction `protobuf:"varint,3,opt,name=direction,proto3,enum=google.monitoring.dashboard.v1.PickTimeSeriesFilter_Direction" json:"direction,omitempty"`
}

func (x *PickTimeSeriesFilter) Reset() {
	*x = PickTimeSeriesFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_common_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PickTimeSeriesFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PickTimeSeriesFilter) ProtoMessage() {}

func (x *PickTimeSeriesFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_common_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PickTimeSeriesFilter.ProtoReflect.Descriptor instead.
func (*PickTimeSeriesFilter) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_common_proto_rawDescGZIP(), []int{1}
}

func (x *PickTimeSeriesFilter) GetRankingMethod() PickTimeSeriesFilter_Method {
	if x != nil {
		return x.RankingMethod
	}
	return PickTimeSeriesFilter_METHOD_UNSPECIFIED
}

func (x *PickTimeSeriesFilter) GetNumTimeSeries() int32 {
	if x != nil {
		return x.NumTimeSeries
	}
	return 0
}

func (x *PickTimeSeriesFilter) GetDirection() PickTimeSeriesFilter_Direction {
	if x != nil {
		return x.Direction
	}
	return PickTimeSeriesFilter_DIRECTION_UNSPECIFIED
}

// A filter that ranks streams based on their statistical relation to other
// streams in a request.
// Note: This field is deprecated and completely ignored by the API.
type StatisticalTimeSeriesFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// `rankingMethod` is applied to a set of time series, and then the produced
	// value for each individual time series is used to compare a given time
	// series to others.
	// These are methods that cannot be applied stream-by-stream, but rather
	// require the full context of a request to evaluate time series.
	RankingMethod StatisticalTimeSeriesFilter_Method `protobuf:"varint,1,opt,name=ranking_method,json=rankingMethod,proto3,enum=google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter_Method" json:"ranking_method,omitempty"`
	// How many time series to output.
	NumTimeSeries int32 `protobuf:"varint,2,opt,name=num_time_series,json=numTimeSeries,proto3" json:"num_time_series,omitempty"`
}

func (x *StatisticalTimeSeriesFilter) Reset() {
	*x = StatisticalTimeSeriesFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_monitoring_dashboard_v1_common_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatisticalTimeSeriesFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatisticalTimeSeriesFilter) ProtoMessage() {}

func (x *StatisticalTimeSeriesFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_monitoring_dashboard_v1_common_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatisticalTimeSeriesFilter.ProtoReflect.Descriptor instead.
func (*StatisticalTimeSeriesFilter) Descriptor() ([]byte, []int) {
	return file_google_monitoring_dashboard_v1_common_proto_rawDescGZIP(), []int{2}
}

func (x *StatisticalTimeSeriesFilter) GetRankingMethod() StatisticalTimeSeriesFilter_Method {
	if x != nil {
		return x.RankingMethod
	}
	return StatisticalTimeSeriesFilter_METHOD_UNSPECIFIED
}

func (x *StatisticalTimeSeriesFilter) GetNumTimeSeries() int32 {
	if x != nil {
		return x.NumTimeSeries
	}
	return 0
}

var File_google_monitoring_dashboard_v1_common_proto protoreflect.FileDescriptor

var file_google_monitoring_dashboard_v1_common_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x87, 0x08,
	0x0a, 0x0b, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a,
	0x10, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x0f, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x12, 0x61, 0x0a, 0x12, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x5f, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x6c, 0x69,
	0x67, 0x6e, 0x65, 0x72, 0x52, 0x10, 0x70, 0x65, 0x72, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x41,
	0x6c, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x12, 0x65, 0x0a, 0x14, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x5f,
	0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x52, 0x65, 0x64, 0x75, 0x63, 0x65, 0x72, 0x52, 0x12, 0x63, 0x72, 0x6f, 0x73, 0x73,
	0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x64, 0x75, 0x63, 0x65, 0x72, 0x12, 0x26, 0x0a,
	0x0f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x62, 0x79, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x79, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0x8b, 0x03, 0x0a, 0x07, 0x41, 0x6c, 0x69, 0x67, 0x6e, 0x65,
	0x72, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10,
	0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x44, 0x45, 0x4c, 0x54, 0x41,
	0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x52, 0x41, 0x54, 0x45,
	0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x49, 0x4e, 0x54, 0x45,
	0x52, 0x50, 0x4f, 0x4c, 0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x4c, 0x49,
	0x47, 0x4e, 0x5f, 0x4e, 0x45, 0x58, 0x54, 0x5f, 0x4f, 0x4c, 0x44, 0x45, 0x52, 0x10, 0x04, 0x12,
	0x0d, 0x0a, 0x09, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x4d, 0x49, 0x4e, 0x10, 0x0a, 0x12, 0x0d,
	0x0a, 0x09, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x4d, 0x41, 0x58, 0x10, 0x0b, 0x12, 0x0e, 0x0a,
	0x0a, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x4d, 0x45, 0x41, 0x4e, 0x10, 0x0c, 0x12, 0x0f, 0x0a,
	0x0b, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x0d, 0x12, 0x0d,
	0x0a, 0x09, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x53, 0x55, 0x4d, 0x10, 0x0e, 0x12, 0x10, 0x0a,
	0x0c, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x53, 0x54, 0x44, 0x44, 0x45, 0x56, 0x10, 0x0f, 0x12,
	0x14, 0x0a, 0x10, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x54,
	0x52, 0x55, 0x45, 0x10, 0x10, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x43,
	0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x46, 0x41, 0x4c, 0x53, 0x45, 0x10, 0x18, 0x12, 0x17, 0x0a, 0x13,
	0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x46, 0x52, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x52, 0x55, 0x45, 0x10, 0x11, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x50,
	0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x49, 0x4c, 0x45, 0x5f, 0x39, 0x39, 0x10, 0x12, 0x12, 0x17,
	0x0a, 0x13, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x49,
	0x4c, 0x45, 0x5f, 0x39, 0x35, 0x10, 0x13, 0x12, 0x17, 0x0a, 0x13, 0x41, 0x4c, 0x49, 0x47, 0x4e,
	0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x49, 0x4c, 0x45, 0x5f, 0x35, 0x30, 0x10, 0x14,
	0x12, 0x17, 0x0a, 0x13, 0x41, 0x4c, 0x49, 0x47, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e,
	0x54, 0x49, 0x4c, 0x45, 0x5f, 0x30, 0x35, 0x10, 0x15, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x4c, 0x49,
	0x47, 0x4e, 0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x48, 0x41, 0x4e, 0x47,
	0x45, 0x10, 0x17, 0x22, 0xb1, 0x02, 0x0a, 0x07, 0x52, 0x65, 0x64, 0x75, 0x63, 0x65, 0x72, 0x12,
	0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00,
	0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x4d, 0x45, 0x41, 0x4e, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x4d, 0x49, 0x4e, 0x10,
	0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x4d, 0x41, 0x58, 0x10,
	0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x53, 0x55, 0x4d, 0x10,
	0x04, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x44, 0x44,
	0x45, 0x56, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x43,
	0x4f, 0x55, 0x4e, 0x54, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45,
	0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x54, 0x52, 0x55, 0x45, 0x10, 0x07, 0x12, 0x16, 0x0a,
	0x12, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x46, 0x41,
	0x4c, 0x53, 0x45, 0x10, 0x0f, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f,
	0x46, 0x52, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x52, 0x55, 0x45, 0x10, 0x08, 0x12,
	0x18, 0x0a, 0x14, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e,
	0x54, 0x49, 0x4c, 0x45, 0x5f, 0x39, 0x39, 0x10, 0x09, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x44,
	0x55, 0x43, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x49, 0x4c, 0x45, 0x5f, 0x39,
	0x35, 0x10, 0x0a, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x50, 0x45,
	0x52, 0x43, 0x45, 0x4e, 0x54, 0x49, 0x4c, 0x45, 0x5f, 0x35, 0x30, 0x10, 0x0b, 0x12, 0x18, 0x0a,
	0x14, 0x52, 0x45, 0x44, 0x55, 0x43, 0x45, 0x5f, 0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x49,
	0x4c, 0x45, 0x5f, 0x30, 0x35, 0x10, 0x0c, 0x22, 0xb3, 0x03, 0x0a, 0x14, 0x50, 0x69, 0x63, 0x6b,
	0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x62, 0x0a, 0x0e, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73,
	0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x69, 0x63, 0x6b, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0d, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6e,
	0x75, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x5c, 0x0a, 0x09,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x69, 0x63, 0x6b, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x74, 0x0a, 0x06, 0x4d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b,
	0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x4d, 0x45, 0x41, 0x4e, 0x10, 0x01, 0x12, 0x0e, 0x0a,
	0x0a, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x4d, 0x41, 0x58, 0x10, 0x02, 0x12, 0x0e, 0x0a,
	0x0a, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x4d, 0x49, 0x4e, 0x10, 0x03, 0x12, 0x0e, 0x0a,
	0x0a, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x53, 0x55, 0x4d, 0x10, 0x04, 0x12, 0x11, 0x0a,
	0x0d, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x4c, 0x41, 0x54, 0x45, 0x53, 0x54, 0x10, 0x05,
	0x22, 0x3b, 0x0a, 0x09, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a,
	0x15, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x54, 0x4f, 0x50, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x4f, 0x54, 0x54, 0x4f, 0x4d, 0x10, 0x02, 0x22, 0xee, 0x01,
	0x0a, 0x1b, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x54, 0x69, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x69, 0x0a,
	0x0e, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f,
	0x61, 0x72, 0x64, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63,
	0x61, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52, 0x0d, 0x72, 0x61, 0x6e, 0x6b, 0x69,
	0x6e, 0x67, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x75, 0x6d, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x22, 0x3c, 0x0a, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x16, 0x0a, 0x12, 0x4d, 0x45,
	0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x43, 0x4c, 0x55,
	0x53, 0x54, 0x45, 0x52, 0x5f, 0x4f, 0x55, 0x54, 0x4c, 0x49, 0x45, 0x52, 0x10, 0x01, 0x42, 0xf5,
	0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2f, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64,
	0x2f, 0x76, 0x31, 0x3b, 0x64, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0xaa, 0x02, 0x24,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x2e, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x24, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x5c, 0x44,
	0x61, 0x73, 0x68, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x28, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x3a, 0x3a, 0x44, 0x61, 0x73, 0x68, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_monitoring_dashboard_v1_common_proto_rawDescOnce sync.Once
	file_google_monitoring_dashboard_v1_common_proto_rawDescData = file_google_monitoring_dashboard_v1_common_proto_rawDesc
)

func file_google_monitoring_dashboard_v1_common_proto_rawDescGZIP() []byte {
	file_google_monitoring_dashboard_v1_common_proto_rawDescOnce.Do(func() {
		file_google_monitoring_dashboard_v1_common_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_monitoring_dashboard_v1_common_proto_rawDescData)
	})
	return file_google_monitoring_dashboard_v1_common_proto_rawDescData
}

var file_google_monitoring_dashboard_v1_common_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_monitoring_dashboard_v1_common_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_google_monitoring_dashboard_v1_common_proto_goTypes = []interface{}{
	(Aggregation_Aligner)(0),                // 0: google.monitoring.dashboard.v1.Aggregation.Aligner
	(Aggregation_Reducer)(0),                // 1: google.monitoring.dashboard.v1.Aggregation.Reducer
	(PickTimeSeriesFilter_Method)(0),        // 2: google.monitoring.dashboard.v1.PickTimeSeriesFilter.Method
	(PickTimeSeriesFilter_Direction)(0),     // 3: google.monitoring.dashboard.v1.PickTimeSeriesFilter.Direction
	(StatisticalTimeSeriesFilter_Method)(0), // 4: google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter.Method
	(*Aggregation)(nil),                     // 5: google.monitoring.dashboard.v1.Aggregation
	(*PickTimeSeriesFilter)(nil),            // 6: google.monitoring.dashboard.v1.PickTimeSeriesFilter
	(*StatisticalTimeSeriesFilter)(nil),     // 7: google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter
	(*durationpb.Duration)(nil),             // 8: google.protobuf.Duration
}
var file_google_monitoring_dashboard_v1_common_proto_depIdxs = []int32{
	8, // 0: google.monitoring.dashboard.v1.Aggregation.alignment_period:type_name -> google.protobuf.Duration
	0, // 1: google.monitoring.dashboard.v1.Aggregation.per_series_aligner:type_name -> google.monitoring.dashboard.v1.Aggregation.Aligner
	1, // 2: google.monitoring.dashboard.v1.Aggregation.cross_series_reducer:type_name -> google.monitoring.dashboard.v1.Aggregation.Reducer
	2, // 3: google.monitoring.dashboard.v1.PickTimeSeriesFilter.ranking_method:type_name -> google.monitoring.dashboard.v1.PickTimeSeriesFilter.Method
	3, // 4: google.monitoring.dashboard.v1.PickTimeSeriesFilter.direction:type_name -> google.monitoring.dashboard.v1.PickTimeSeriesFilter.Direction
	4, // 5: google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter.ranking_method:type_name -> google.monitoring.dashboard.v1.StatisticalTimeSeriesFilter.Method
	6, // [6:6] is the sub-list for method output_type
	6, // [6:6] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_google_monitoring_dashboard_v1_common_proto_init() }
func file_google_monitoring_dashboard_v1_common_proto_init() {
	if File_google_monitoring_dashboard_v1_common_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_monitoring_dashboard_v1_common_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Aggregation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_dashboard_v1_common_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PickTimeSeriesFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_monitoring_dashboard_v1_common_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatisticalTimeSeriesFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_monitoring_dashboard_v1_common_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_monitoring_dashboard_v1_common_proto_goTypes,
		DependencyIndexes: file_google_monitoring_dashboard_v1_common_proto_depIdxs,
		EnumInfos:         file_google_monitoring_dashboard_v1_common_proto_enumTypes,
		MessageInfos:      file_google_monitoring_dashboard_v1_common_proto_msgTypes,
	}.Build()
	File_google_monitoring_dashboard_v1_common_proto = out.File
	file_google_monitoring_dashboard_v1_common_proto_rawDesc = nil
	file_google_monitoring_dashboard_v1_common_proto_goTypes = nil
	file_google_monitoring_dashboard_v1_common_proto_depIdxs = nil
}
