/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ScmTextComponent;

public class TextField
extends Item {
    public static final int ANY = 0;
    public static final int CONSTRAINT_MASK = 65535;
    public static final int EMAILADDR = 1;
    public static final int NUMERIC = 2;
    public static final int PASSWORD = 65536;
    public static final int PHONENUMBER = 3;
    public static final int URL = 4;
    public static final int DECIMAL = 5;
    public static final int UNEDITABLE = 131072;
    public static final int SENSITIVE = 262144;
    public static final int NON_PREDICTIVE = 524288;
    public static final int INITIAL_CAPS_WORD = 0x100000;
    public static final int INITIAL_CAPS_SENTENCE = 0x200000;
    ScmTextComponent field;

    public TextField(String label, String text, int maxSize, int constraints) {
        super(label);
        if (text == null) {
            text = "";
        }
        if (maxSize <= 0) {
            throw new RuntimeException("The maxSize on the TextField should be more than 0 actual value: " + maxSize);
        }
        if (constraints < 0) {
            constraints = 0;
        }
        if (text.length() > maxSize) {
            text = text.substring(0, maxSize);
        }
        this.field = new ScmTextComponent(this, "textField", true);
        this.field.setText(text);
        this.field.setMaxSize(maxSize);
        this.field.setConstraints(constraints);
        this.lines.addElement(this.field);
    }

    public void delete(int offset, int length) {
        String s = this.getString();
        this.setString(s.substring(0, offset) + s.substring(offset + length));
    }

    public int getCaretPosition() {
        return this.field.getCaretPosition();
    }

    public int getChars(char[] data) {
        String s = this.getString();
        int l = s.length();
        s.getChars(0, l, data, 0);
        return l;
    }

    public int getConstraints() {
        return this.field.getConstraints();
    }

    public int getMaxSize() {
        return this.field.getMaxSize();
    }

    public String getString() {
        return this.field.getText();
    }

    public void insert(char[] data, int offset, int length, int position) {
        this.insert(new String(data, offset, length), position);
    }

    public void insert(String src, int position) {
        String s = this.getString();
        this.setString(s.substring(0, position) + src + s.substring(position));
    }

    public void setChars(char[] data, int offset, int length) {
        this.setString(new String(data, offset, length));
    }

    public void setConstraints(int constraints) {
        this.field.setConstraints(constraints);
    }

    public int setMaxSize(int maxSize) {
        return this.field.setMaxSize(maxSize);
    }

    public void setString(String text) {
        this.field.setText(text);
    }

    public int size() {
        return this.getString().length();
    }

    public void setInitialInputMode(String characterSubset) {
    }
}

