/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.scm;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import org.me4se.scm.ScmComponent;

public class ScmScrollBar
extends ScmComponent {
    int value;
    int maximum = 100;
    int visibleAmount = 1;
    int minimumHandleSize = 5;
    Color foreground = Color.black;

    public int getMaximum() {
        return this.maximum;
    }

    public int getValue() {
        return this.value;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.maximum == 0) {
            return;
        }
        ScmComponent c = this;
        while (c.background == null && c.parent != null) {
            c = c.parent;
        }
        Color bg = c.background == null ? Color.white : c.background;
        g.setColor(new Color((this.foreground.getRed() + bg.getRed()) / 2, (this.foreground.getGreen() + bg.getGreen()) / 2, (this.foreground.getBlue() + bg.getBlue()) / 2));
        int range = this.getHeight() - this.minimumHandleSize;
        int pos = range * this.value / this.maximum + this.minimumHandleSize / 2;
        int size = range * this.visibleAmount / this.maximum;
        g.fillRect(2, 0, this.w - 2, pos - 1);
        g.fillRect(2, pos + size + 1, this.w - 2, this.h - pos - size - 1);
        g.setColor(this.foreground);
        g.fillRect(1, pos, this.w - 1, size);
    }

    public void setForeground(Color fg) {
        this.foreground = fg;
    }

    public void setMaximum(int mx) {
        this.maximum = mx;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setVisibleAmount(int visibleAmount) {
        this.visibleAmount = visibleAmount;
    }

    public Dimension getMinimumSize() {
        return new Dimension(4, 10);
    }
}

