/* free some structures

   Written by Matthias Hensler
   Copyright WSPse 1999
   eMail: wsp@gmx.de

Created: 5/6/99
Updated: 6/9/99
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include "mp3creat.h"

void free_field_select(field_select_typ **anchor)
{
  field_select_typ *curr, *next;

  curr = *anchor;
  while(curr != NULL) {
#ifdef DEBUG
    fprintf(stderr, "DEBUG: free: \"%s\"\n", curr->information);
#endif
    if(curr->field)       free(curr->field);
    if(curr->dest)        free(curr->dest);
    if(curr->information) free(curr->information);
    next = curr->next;
    free(curr);
    curr = next;
  }
}

void free_song_typ(song_typ **anchor)
{
  song_typ *curr, *next;

  curr = *anchor;
  while(curr != NULL) {
#ifdef DEBUG
    fprintf(stderr, "DEBUG: free: \"%s\"\n", curr->title);
#endif
    if(curr->artist)       free(curr->artist);
    if(curr->title)        free(curr->title);
    if(curr->album)        free(curr->album);
    if(curr->comment)      free(curr->comment);
    if(curr->filename)     free(curr->filename);
    if(curr->dirname)      free(curr->dirname);
    if(curr->tmp_wav_file) free(curr->tmp_wav_file);
    
    next = curr->next;
    free(curr);
    curr = next;
  }
}

void free_char_array(char **array)
{
  int i;
  
  i = 0;
  while(array) {
    if(! array[i]) break;
    free(array[i]);
    i++;
  }
  if(array) free(array);
}

