/* manage different windows

   Written by Matthias Hensler
   Copyright WSPse 1999
   eMail: wsp@gmx.de

Created: 9/6/99
Updated: 20/11/99
*/

/* Copying:
   This program is free software; you can redistribute it and/or modify it under
   the terms of the GNU Gerneral Public License as published by the Free Soft-
   ware Foundation; either version 2 of License, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILTY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 675 Mass
   Ave, Cambridge, MA 02139, USA.
   */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <ncurses.h>
#include "mp3creat.h"

extern void wuuush(int);

typedef struct tmp {
  WINDOW *win;
  void (*proc) (WINDOW *win, int arg1, int arg2);
  int arg1;
  int arg2;
  void *pointer;
  struct tmp *next;
  struct tmp *prev;
} lifo_type;

lifo_type *active_win  = NULL;
lifo_type *lifo_anchor = NULL;

WINDOW *c_newwin(int h, int l, int y, int x, void *proc, int arg1, int arg2)
{
  lifo_type *new;
  int i;

  new = (lifo_type *) malloc(sizeof(lifo_type));
  if(new == NULL) {
    perror("malloc");
    wuuush(1);
  }
  new->win     = newwin(h,l,y,x);
  new->proc    = proc;
  new->arg1    = arg1;
  new->arg2    = arg2;
  new->next    = NULL;
  new->prev    = lifo_anchor;
  if(lifo_anchor) lifo_anchor->next = new;
  else            lifo_anchor       = new;
  active_win   = new;

  /* So this results in a problem I discovered, but could not reproduce it.
   * I definitly got a NULL-pointer from newwin()-function call, but there
   * wasn't any reason for it ;-)
   * So I think ncurses might be a problem and give it a new chance (ok
   * actually 100 tries ;-) */
  i = 0;
  while((new->win == NULL) && (i < 100)) {
    new->win = newwin(h,l,y,x);
    i++;
  }
  
  /* As a last try I claim a fullscreen-window */
  if(new->win == NULL) {
    new->win = newwin(0,0,0,0);
  }
  
  /* So, I got no window at all, last resort: exit */
  if(new->win == NULL) {
    wuuush(3);
  }

  return new->win;
}

void lifo_rebuild(lifo_type *win)
{
  win->proc (win->win, win->arg1, win->arg2);
  touchwin(win->win);
  wrefresh(win->win);
}

void lifo_refresh()
{
  lifo_type *curr;

  curr = lifo_anchor;
  while(curr) {
    lifo_rebuild(curr);
    if(curr == active_win) break;
    curr = curr->next;
  }
}

int set_active_win(WINDOW *win)
{
  lifo_type *curr;

  curr = lifo_anchor;
  while(curr) {
    if(win == curr->win) {
      active_win = curr;
      lifo_refresh();
      return 0;
    }
    curr = curr->next;
  }
  return -1;
}

void c_delwin(WINDOW *win)
{
  lifo_type *curr;

  curr = lifo_anchor;
  while(curr != NULL) {
    if(curr->win == win) {
      delwin(curr->win);
      if(curr->prev != NULL) {
	if(curr->next != NULL) {
	  curr->next->prev = curr->prev;
	  curr->prev->next = curr->next;
	  set_active_win(curr->next->win);
	  free(curr);
	  return;
	} else {
	  curr->prev->next = NULL;
	  set_active_win(curr->prev->win);
	  free(curr);
	  return;
	}
      } else if(curr->next != NULL) {
	lifo_anchor = curr->next;
	set_active_win(curr->next->win);
	free(curr);
	return;
      } else {
	free(curr);
	lifo_anchor = NULL;
	return;
      }
    }
    curr = curr->next;
  }
}

void store_win_poi(WINDOW *win, void *pointer)
{
  lifo_type *curr;

  curr = lifo_anchor;
  while(curr) {
    if(curr->win == win) {
      curr->pointer = pointer;
      return;
    }
    curr = curr->next;
  }
}

void *pop_win_poi(WINDOW *win)
{
  lifo_type *curr;

  curr = lifo_anchor;
  while(curr) {
    if(curr->win == win) {
      return curr->pointer;
    }
    curr = curr->next;
  }
  return NULL;
}

