#ifndef __QT_PIXMAP_H__
#define __QT_PIXMAP_H__

/*
 * QTPixmap GTK engine
 *
 * This is a hacked/modified version of the Pixmap GTK engine. Modified to use
 * ~/.qt/qtrc to get colour information to recolour widgets.
 *
 * Changes are (C) Craig Drummond 2002 - Craig.Drummond@lycos.co.uk
 * 
 */

#include <gtk/gtk.h>
#include <gdk_imlib.h>
#include "common.h"

/* internals */

typedef struct
  {
    guint refcount;
    GList *img_list;
    gint  xthickness,
          ythickness;
  }
ThemeData;

enum
  {
    TOKEN_IMAGE = G_TOKEN_LAST + 1,
    TOKEN_BUTTON_X_OFFSET,
    TOKEN_BUTTON_Y_OFFSET,
    TOKEN_TB_BUTTON_X_OFFSET,
    TOKEN_TB_BUTTON_Y_OFFSET,
    TOKEN_FUNCTION,
    TOKEN_FILE,
    TOKEN_STRETCH,
    TOKEN_RECOLORABLE,
    TOKEN_BORDER,
    TOKEN_DETAIL,
    TOKEN_STATE,
    TOKEN_SHADOW,
    TOKEN_GAP_SIDE,
    TOKEN_GAP_FILE,
    TOKEN_GAP_BORDER,
    TOKEN_GAP_START_FILE,
    TOKEN_GAP_START_BORDER,
    TOKEN_GAP_END_FILE,
    TOKEN_GAP_END_BORDER,
    TOKEN_OVERLAY_FILE,
    TOKEN_OVERLAY_BORDER,
    TOKEN_OVERLAY_STRETCH,
    TOKEN_ARROW_DIRECTION,
    TOKEN_FILE_COLOR,
    TOKEN_GAP_FILE_COLOR,
    TOKEN_GAP_START_FILE_COLOR,
    TOKEN_GAP_END_FILE_COLOR,
    TOKEN_OVERLAY_FILE_COLOR,
    TOKEN_FILE_COLOR_MOD,
    TOKEN_GAP_FILE_COLOR_MOD,
    TOKEN_GAP_START_FILE_COLOR_MOD,
    TOKEN_GAP_END_FILE_COLOR_MOD,
    TOKEN_OVERLAY_FILE_COLOR_MOD,
    TOKEN_OVERLAY_MIN_SIZE,
    TOKEN_NO_RADIO_CHECK_HIGHLIGHT,
    TOKEN_BUTTON_FOCUS_MOD,
    TOKEN_COMBO_FOCUS_MOD,
    TOKEN_RADIO_CHECK_FOCUS_MOD,
    TOKEN_USE_SELECTED_FOR_MENU_ITEM,
    TOKEN_USE_SELECTED_FOR_MENU,
    TOKEN_D_HLINE,
    TOKEN_D_VLINE,
    TOKEN_D_SHADOW,
    TOKEN_D_POLYGON,
    TOKEN_D_ARROW,
    TOKEN_D_DIAMOND,
    TOKEN_D_OVAL,
    TOKEN_D_STRING,
    TOKEN_D_BOX,
    TOKEN_D_FLAT_BOX,
    TOKEN_D_CHECK,
    TOKEN_D_OPTION,
    TOKEN_D_CROSS,
    TOKEN_D_RAMP,
    TOKEN_D_TAB,
    TOKEN_D_SHADOW_GAP,
    TOKEN_D_BOX_GAP,
    TOKEN_D_EXTENSION,
    TOKEN_D_FOCUS,
    TOKEN_D_SLIDER,
    TOKEN_D_ENTRY,
    TOKEN_D_HANDLE,
    TOKEN_TRUE,
    TOKEN_FALSE,
    TOKEN_TOP,
    TOKEN_UP,
    TOKEN_BOTTOM,
    TOKEN_DOWN,
    TOKEN_LEFT,
    TOKEN_RIGHT,
    TOKEN_NORMAL,
    TOKEN_ACTIVE,
    TOKEN_PRELIGHT,
    TOKEN_SELECTED,
    TOKEN_INSENSITIVE,
    TOKEN_NONE,
    TOKEN_IN,
    TOKEN_OUT,
    TOKEN_ETCHED_IN,
    TOKEN_ETCHED_OUT,
    TOKEN_ORIENTATION,
    TOKEN_HORIZONTAL,
    TOKEN_VERTICAL,

    TOKEN_XTHICK,
    TOKEN_YTHICK
  };

struct image_data
{
    struct image_file file;
    GdkImlibImage     *img;
};

struct theme_image
  {
    guint               refcount;

    guint               function;
    gchar               recolorable;
    gchar              *detail;
    struct image_data   file;
    GdkImlibBorder      border;
    enum fstretch       stretch;
    struct image_data   overlay_file;
    GdkImlibBorder      overlay_border;
    enum fstretch       overlay_stretch;
    struct image_size   overlay_min_size;
    struct image_data   gap_file;
    GdkImlibBorder      gap_border;

    struct image_data   gap_start_file;
    GdkImlibBorder      gap_start_border;
    struct image_data   gap_end_file;
    GdkImlibBorder      gap_end_border;
    
    gchar               __gap_side;
    GtkPositionType     gap_side;
    gchar               __orientation;
    GtkOrientation      orientation;
    gchar               __state;
    GtkStateType        state;
    gchar               __shadow;
    GtkShadowType       shadow;
    gchar               __arrow_direction;
    GtkArrowType        arrow_direction;
  };

#endif
