# GoDaddy module for Caddy

This package contains a DNS provider module for [Caddy](https://github.com/caddyserver/caddy). It can be used to manage DNS records with GoDaddy accounts.

## Caddy module name

```
dns.providers.godaddy
```

## Config examples

`api_token` should be in the format `<GODADDY_API_KEY>:<GODADDY_API_SECRET>`. You can obtain these credentials from your GoDaddy account.

To use this module for the ACME DNS challenge, [configure the ACME issuer in your Caddy JSON](https://caddyserver.com/docs/json/apps/tls/automation/policies/issuer/acme/) like so:

```
{
	"module": "acme",
	"challenges": {
		"dns": {
			"provider": {
				"name": "godaddy",
				"api_token": "YOUR_GODADDY_API_TOKEN"
			}
		}
	}
}
```

or with the Caddyfile:

```
# globally
{
	acme_dns godaddy {
		api_token {env.GODADDY_API_TOKEN}
	}
}
```

```
# one site
tls {
  dns godaddy {
    api_token {env.GODADDY_API_TOKEN}
  }
}
```

You can replace `{env.GODADDY_API_TOKEN}` with the actual auth token if you prefer to put it directly in your config instead of an environment variable.

## Authenticating

See [the associated README in the libdns package](https://github.com/libdns/godaddy) for important information about credentials.
