// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EnvVarValue Environment variable value model definition
//
// swagger:model envVarValue
type EnvVarValue struct {

	// The deploy context in which this value will be used. `dev` refers to local development when running `netlify dev`.
	// Enum: [all dev branch-deploy deploy-preview production branch]
	Context string `json:"context,omitempty"`

	// An additional parameter for custom branches. Currently, this is used for specifying a branch name when `context=branch`.
	ContextParameter string `json:"context_parameter,omitempty"`

	// The environment variable value's universally unique ID
	ID string `json:"id,omitempty"`

	// The environment variable's unencrypted value
	Value string `json:"value,omitempty"`
}

// Validate validates this env var value
func (m *EnvVarValue) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateContext(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var envVarValueTypeContextPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["all","dev","branch-deploy","deploy-preview","production","branch"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		envVarValueTypeContextPropEnum = append(envVarValueTypeContextPropEnum, v)
	}
}

const (

	// EnvVarValueContextAll captures enum value "all"
	EnvVarValueContextAll string = "all"

	// EnvVarValueContextDev captures enum value "dev"
	EnvVarValueContextDev string = "dev"

	// EnvVarValueContextBranchDeploy captures enum value "branch-deploy"
	EnvVarValueContextBranchDeploy string = "branch-deploy"

	// EnvVarValueContextDeployPreview captures enum value "deploy-preview"
	EnvVarValueContextDeployPreview string = "deploy-preview"

	// EnvVarValueContextProduction captures enum value "production"
	EnvVarValueContextProduction string = "production"

	// EnvVarValueContextBranch captures enum value "branch"
	EnvVarValueContextBranch string = "branch"
)

// prop value enum
func (m *EnvVarValue) validateContextEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, envVarValueTypeContextPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *EnvVarValue) validateContext(formats strfmt.Registry) error {

	if swag.IsZero(m.Context) { // not required
		return nil
	}

	// value enum
	if err := m.validateContextEnum("context", "body", m.Context); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *EnvVarValue) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EnvVarValue) UnmarshalBinary(b []byte) error {
	var res EnvVarValue
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
