// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//go:build aix || darwin || dragonfly || freebsd || (js && wasm) || linux || netbsd || openbsd || solaris
// +build aix darwin dragonfly freebsd js,wasm linux netbsd openbsd solaris

package storageos

// ProviderWithSymlinks returns a ProviderOption that results in symlink support.
//
// Note that ReadWriteBucketWithSymlinksEnabled still needs to be passed for a given
// ReadWriteBucket to have symlinks followed.
func ProviderWithSymlinks() ProviderOption {
	return func(provider *provider) {
		provider.symlinks = true
	}
}
