/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.JxmppContext;

public abstract class EmbeddedExtensionProvider<PE extends XmlElement>
extends ExtensionElementProvider<PE> {
    @Override
    public final PE parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        XmlPullParser.Event event;
        String namespace = parser.getNamespace();
        String name = parser.getName();
        int attributeCount = parser.getAttributeCount();
        HashMap<String, String> attMap = new HashMap<String, String>(attributeCount);
        for (int i = 0; i < attributeCount; ++i) {
            attMap.put(parser.getAttributeName(i), parser.getAttributeValue(i));
        }
        ArrayList<XmlElement> extensions = new ArrayList<XmlElement>();
        do {
            if ((event = parser.next()) != XmlPullParser.Event.START_ELEMENT) continue;
            PacketParserUtils.addExtensionElement(extensions, parser, xmlEnvironment, jxmppContext);
        } while (event != XmlPullParser.Event.END_ELEMENT || parser.getDepth() != initialDepth);
        return this.createReturnExtension(name, namespace, attMap, extensions);
    }

    protected abstract PE createReturnExtension(String var1, String var2, Map<String, String> var3, List<? extends XmlElement> var4);
}

