/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.key.generation.KeySpecBuilder;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsHelper;

public class KeySpec {
    private final KeyType keyType;
    private final SignatureSubpackets subpacketGenerator;
    private final boolean inheritedSubPackets;
    private final Date keyCreationDate;

    KeySpec(@Nonnull KeyType type, @Nonnull SignatureSubpackets subpacketGenerator, boolean inheritedSubPackets, @Nullable Date keyCreationDate) {
        this.keyType = type;
        this.subpacketGenerator = subpacketGenerator;
        this.inheritedSubPackets = inheritedSubPackets;
        this.keyCreationDate = keyCreationDate;
    }

    @Nonnull
    public KeyType getKeyType() {
        return this.keyType;
    }

    @Nonnull
    public PGPSignatureSubpacketVector getSubpackets() {
        return SignatureSubpacketsHelper.toVector(this.subpacketGenerator);
    }

    @Nonnull
    public SignatureSubpackets getSubpacketGenerator() {
        return this.subpacketGenerator;
    }

    boolean isInheritedSubPackets() {
        return this.inheritedSubPackets;
    }

    @Nullable
    public Date getKeyCreationDate() {
        return this.keyCreationDate;
    }

    public static KeySpecBuilder getBuilder(KeyType type, KeyFlag flag, KeyFlag ... flags) {
        return new KeySpecBuilder(type, flag, flags);
    }
}

