<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/health/notifications/pushbullet/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/health/notifications/pushbullet/metadata.yaml"
sidebar_label: "Pushbullet"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# Pushbullet


<img src="https://netdata.cloud/img/pushbullet.png" width="150"/>


Send notifications to Pushbullet using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.



<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

#### 

- A Pushbullet access token that can be created in your [account settings](https://www.pushbullet.com/#settings/account).
- Access to the terminal where Netdata Agent is running



### Configuration

#### File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```
#### Options

The following options can be defined for this notification

<details open><summary>Config Options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| Send_PUSHBULLET | Set `Send_PUSHBULLET` to YES | YES | yes |
| PUSHBULLET_ACCESS_TOKEN | set `PUSHBULLET_ACCESS_TOKEN` to the access token you generated. |  | yes |
| DEFAULT_RECIPIENT_PUSHBULLET | Set `DEFAULT_RECIPIENT_PUSHBULLET` to the email (e.g. `example@domain.com`) or the channel tag (e.g. `#channel`) you want the alert notifications to be sent to. |  | yes |

##### DEFAULT_RECIPIENT_PUSHBULLET

You can define multiple entries like this: user1@email.com user2@email.com.

All roles will default to this variable if left unconfigured.

The `DEFAULT_RECIPIENT_PUSHBULLET` can be edited in the following entries at the bottom of the same file:
```text
role_recipients_pushbullet[sysadmin]="user1@email.com"
role_recipients_pushbullet[domainadmin]="user2@mail.com"
role_recipients_pushbullet[dba]="#channel1"
role_recipients_pushbullet[webmaster]="#channel2"
role_recipients_pushbullet[proxyadmin]="user3@mail.com"
role_recipients_pushbullet[sitemgr]="user4@mail.com"
```


</details>

#### Examples

##### Basic Configuration



```yaml
#------------------------------------------------------------------------------
# pushbullet (pushbullet.com) push notification options

SEND_PUSHBULLET="YES"
PUSHBULLET_ACCESS_TOKEN="XXXXXXXXX"
DEFAULT_RECIPIENT_PUSHBULLET="admin1@example.com admin3@somemail.com #examplechanneltag #anotherchanneltag"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


