# generated by datamodel-codegen:
#   filename:  intoto_schema.json
#   version:   0.26.3

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import BaseModel, ConfigDict, Field, RootModel, StrictStr


class Algorithm(str, Enum):
    """The hashing function used to compute the hash value"""

    SHA256 = "sha256"


class Hash(BaseModel):
    """Specifies the hash algorithm and value encompassing the entire signed envelope; this is computed by the rekor server, client-provided values are ignored"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value for the archive")


class PayloadHash(BaseModel):
    """Specifies the hash algorithm and value covering the payload within the DSSE envelope; this is computed by the rekor server, client-provided values are ignored"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value for the envelope's payload")


class Content(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    envelope: Optional[StrictStr] = Field(default=None, description="envelope")
    hash: Optional[Hash] = Field(
        default=None,
        description="Specifies the hash algorithm and value encompassing the entire signed envelope; this is computed by the rekor server, client-provided values are ignored",
    )
    payload_hash: Optional[PayloadHash] = Field(
        default=None,
        alias="payloadHash",
        description="Specifies the hash algorithm and value covering the payload within the DSSE envelope; this is computed by the rekor server, client-provided values are ignored",
    )


class IntotoV001Schema(BaseModel):
    """Schema for intoto object"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Content
    public_key: str = Field(
        ...,
        alias="publicKey",
        description="The public key that can verify the signature",
    )


class Signature(BaseModel):
    """a signature of the envelope's payload along with the public key for the signature"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    keyid: Optional[StrictStr] = Field(
        default=None,
        description="optional id of the key used to create the signature",
    )
    sig: str = Field(..., description="signature of the payload")
    public_key: str = Field(
        ...,
        alias="publicKey",
        description="public key that corresponds to this signature",
    )


class Envelope(BaseModel):
    """dsse envelope"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    payload: Optional[str] = Field(default=None, description="payload of the envelope")
    payload_type: StrictStr = Field(
        ...,
        alias="payloadType",
        description="type describing the payload",
    )
    signatures: List[Signature] = Field(
        ...,
        description="collection of all signatures of the envelope's payload",
        min_length=1,
    )


class Hash1(BaseModel):
    """Specifies the hash algorithm and value encompassing the entire signed envelope"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value for the archive")


class PayloadHash1(BaseModel):
    """Specifies the hash algorithm and value covering the payload within the DSSE envelope"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    algorithm: Algorithm = Field(
        ...,
        description="The hashing function used to compute the hash value",
    )
    value: StrictStr = Field(..., description="The hash value of the payload")


class Content1(BaseModel):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    envelope: Envelope = Field(..., description="dsse envelope")
    hash: Optional[Hash1] = Field(
        default=None,
        description="Specifies the hash algorithm and value encompassing the entire signed envelope",
    )
    payload_hash: Optional[PayloadHash1] = Field(
        default=None,
        alias="payloadHash",
        description="Specifies the hash algorithm and value covering the payload within the DSSE envelope",
    )


class IntotoV002Schema(BaseModel):
    """Schema for intoto object"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Content1


class IntotoSchema(RootModel[Union[IntotoV001Schema, IntotoV002Schema]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: Union[IntotoV001Schema, IntotoV002Schema] = Field(
        ...,
        description="Intoto for Rekord objects",
        title="Intoto Schema",
    )
