# generated by datamodel-codegen:
#   filename:  tuf_schema.json
#   version:   0.26.3

from __future__ import annotations

from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict, Field, RootModel, StrictStr


class Metadata(BaseModel):
    """TUF metadata"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Dict[str, Any] = Field(
        ...,
        description="Specifies the metadata inline within the document",
    )


class Root(BaseModel):
    """root metadata containing about the public keys used to sign the manifest"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    content: Dict[str, Any] = Field(
        ...,
        description="Specifies the metadata inline within the document",
    )


class TufV001Schema(BaseModel):
    """Schema for TUF metadata entries"""

    model_config = ConfigDict(
        populate_by_name=True,
    )
    spec_version: Optional[StrictStr] = Field(default=None, description="TUF specification version")
    metadata: Metadata = Field(..., description="TUF metadata")
    root: Root = Field(
        ...,
        description="root metadata containing about the public keys used to sign the manifest",
    )


class TufSchema(RootModel[TufV001Schema]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: TufV001Schema = Field(
        ...,
        description="Schema for TUF metadata objects",
        title="TUF Schema",
    )
