//
// FLUID template support for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2020 by Bill Spitzak and others.
//
// This library is free software. Distribution and use rights are outlined in
// the file "COPYING" which should have been included with this file.  If this
// file is missing or damaged, see the license at:
//
//     https://www.fltk.org/COPYING.php
//
// Please see the following page on how to report bugs and issues:
//
//     https://www.fltk.org/bugs.php
//

// generated by Fast Light User Interface Designer (fluid) version 1.0400

#include "template_panel.h"
#include "fluid.h"
#include <FL/Fl_Shared_Image.H>
#include <FL/fl_ask.H>
#include <FL/fl_string_functions.h>
#include "fluid_filename.h"
#include "../src/flstring.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <zlib.h>
#if defined(_WIN32) && !defined(__CYGWIN__)
#include <io.h>
#else
#include <unistd.h>
#endif // _WIN32 && !__CYGWIN__

Fl_Double_Window *template_panel=(Fl_Double_Window *)0;

static void cb_template_panel(Fl_Double_Window*, void*) {
  Fl_Shared_Image *img = (Fl_Shared_Image *)template_preview->image();
  if (img) img->release();
  template_preview->image(0);

  template_browser->deselect();
  template_name->value("");
  template_instance->value("");
  template_panel->hide();
}

Fl_Browser *template_browser=(Fl_Browser *)0;

static void cb_template_browser(Fl_Browser*, void*) {
  if (Fl::event_clicks()) {
    template_panel->hide();
    return;
  }
  Fl_Shared_Image *img = (Fl_Shared_Image *)template_preview->image();
  if (img) img->release();
  template_preview->image(0);
  template_preview->redraw();

  int item = template_browser->value();

  if (item <= 1) template_instance->deactivate();
  else template_instance->activate();

  if (item < 1) {
    template_submit->deactivate();
    template_delete->deactivate();
    return;
  }

  template_submit->activate();

  const char *flfile = (const char *)template_browser->data(item);
  if (!flfile) {
    template_delete->deactivate();
    return;
  }

  template_name->value(template_browser->text(item));

  template_delete->activate();

  char pngfile[1024], *ext;

  strlcpy(pngfile, flfile, sizeof(pngfile));
  if ((ext = strrchr(pngfile, '.')) == NULL) return;
  strcpy(ext, ".png");

  img = Fl_Shared_Image::get(pngfile);

  if (img) {
    template_preview->image(img);
    template_preview->redraw();
  }
}

Fl_Box *template_preview=(Fl_Box *)0;

Fl_Input *template_name=(Fl_Input *)0;

static void cb_template_name(Fl_Input*, void*) {
  if (strlen(template_name->value())) {
    template_submit->activate();
    if (Fl::event_key() == FL_Enter) template_panel->hide();
  } else template_submit->deactivate();
}

Fl_Input *template_instance=(Fl_Input *)0;

Fl_Button *template_delete=(Fl_Button *)0;

static void cb_Cancel(Fl_Button*, void*) {
  Fl_Shared_Image *img = (Fl_Shared_Image *)template_preview->image();
  if (img) img->release();
  template_preview->image(0);

  template_browser->deselect();
  template_name->value("");
  template_instance->value("");
  template_panel->hide();
}

Fl_Return_Button *template_submit=(Fl_Return_Button *)0;

static void cb_template_submit(Fl_Return_Button*, void*) {
  Fl_Shared_Image *img = (Fl_Shared_Image *)template_preview->image();
  if (img) img->release();
  template_preview->image(0);

  template_panel->hide();
}

Fl_Double_Window* make_template_panel() {
  { template_panel = new Fl_Double_Window(460, 355, "New/Save Template");
    template_panel->callback((Fl_Callback*)cb_template_panel);
    { template_browser = new Fl_Browser(10, 28, 180, 250, "Available Templates:");
      template_browser->type(2);
      template_browser->labelfont(1);
      template_browser->callback((Fl_Callback*)cb_template_browser);
      template_browser->align(Fl_Align(FL_ALIGN_TOP_LEFT));
      template_browser->when(FL_WHEN_CHANGED | FL_WHEN_NOT_CHANGED);
    } // Fl_Browser* template_browser
    { template_preview = new Fl_Box(200, 28, 250, 250);
      template_preview->box(FL_THIN_DOWN_BOX);
      template_preview->align(Fl_Align(FL_ALIGN_CLIP|FL_ALIGN_INSIDE));
      Fl_Group::current()->resizable(template_preview);
    } // Fl_Box* template_preview
    { template_name = new Fl_Input(198, 288, 252, 25, "Template Name:");
      template_name->labelfont(1);
      template_name->textfont(4);
      template_name->callback((Fl_Callback*)cb_template_name);
      template_name->when(FL_WHEN_CHANGED | FL_WHEN_NOT_CHANGED);
    } // Fl_Input* template_name
    { template_instance = new Fl_Input(198, 288, 252, 25, "Instance Name:");
      template_instance->labelfont(1);
      template_instance->textfont(4);
      template_instance->hide();
    } // Fl_Input* template_instance
    { Fl_Group* o = new Fl_Group(10, 323, 440, 25);
      { template_delete = new Fl_Button(10, 323, 143, 25, "Delete Template");
        template_delete->callback((Fl_Callback*)template_delete_cb);
      } // Fl_Button* template_delete
      { Fl_Box* o = new Fl_Box(153, 323, 126, 25);
        Fl_Group::current()->resizable(o);
      } // Fl_Box* o
      { Fl_Button* o = new Fl_Button(289, 323, 72, 25, "Cancel");
        o->callback((Fl_Callback*)cb_Cancel);
      } // Fl_Button* o
      { template_submit = new Fl_Return_Button(371, 323, 79, 25, "Save");
        template_submit->callback((Fl_Callback*)cb_template_submit);
      } // Fl_Return_Button* template_submit
      o->end();
    } // Fl_Group* o
    template_panel->set_modal();
    template_panel->end();
  } // Fl_Double_Window* template_panel
  return template_panel;
}

void template_clear() {
  int i;
  void *filename;

  for (i = 1; i <= template_browser->size(); i ++) {
    if ((filename = template_browser->data(i)) != NULL) free(filename);
  }

  template_browser->deselect();
  template_browser->clear();
}

void template_delete_cb(Fl_Button *, void *) {
  int item = template_browser->value();
  if (item < 1) return;

  const char *name = template_browser->text(item);
  const char *flfile = (const char *)template_browser->data(item);
  if (!flfile) return;

  if (!fl_choice("Are you sure you want to delete the template \"%s\"?",
                 "Cancel", "Delete", 0, name)) return;

  if (fl_unlink(flfile)) {
    fl_alert("Unable to delete template \"%s\":\n%s", name, strerror(errno));
    return;
  }

  char pngfile[1024], *ext;
  strlcpy(pngfile, flfile, sizeof(pngfile));
  if ((ext = strrchr(pngfile, '.')) != NULL) {
    strcpy(ext, ".png");
    fl_unlink(pngfile);
  }

  template_browser->remove(item);
  template_browser->do_callback();
}

static int tmpl_FLTK_License_fl_size = 623;
static unsigned char tmpl_FLTK_License_fl[401] = /* data compressed and inlined from templates/FLTK_License.fl */
{120,156,133,82,77,79,220,48,16,189,231,87,60,209,11,72,109,178,208,30,10,
39,218,165,84,43,208,22,137,237,161,39,228,196,147,120,132,99,71,246,132,176,
93,237,127,199,14,187,234,177,62,217,227,247,53,99,127,128,86,162,208,178,37,
180,62,64,12,225,214,202,51,126,71,10,88,57,161,208,170,134,112,67,145,59,151,
74,167,173,29,89,159,21,47,20,34,123,135,243,114,241,101,177,40,12,41,77,225,
201,169,158,176,43,205,190,104,188,166,227,177,121,125,205,133,190,39,39,216,85,
85,81,85,184,94,173,31,55,223,214,203,31,215,255,124,85,20,220,115,103,4,27,
239,45,238,88,112,122,123,191,185,59,43,139,119,210,210,15,219,48,3,206,47,47,
191,126,186,88,92,124,70,189,197,119,182,22,143,3,203,95,245,12,229,52,124,146,
11,241,200,218,24,142,176,92,7,21,182,72,219,54,16,33,250,86,38,21,168,196,13,
71,9,92,143,146,219,201,236,49,18,102,151,136,4,128,31,197,178,35,13,118,89,45,
39,157,199,117,178,252,245,240,103,181,254,121,130,201,112,99,16,141,31,173,
134,81,47,132,154,200,37,124,99,71,157,136,19,139,73,188,108,157,136,37,176,106,
231,99,150,155,165,210,77,207,49,178,235,144,102,161,85,175,58,210,31,17,83,206,
108,103,185,33,151,66,41,185,58,180,148,151,17,25,226,85,85,77,211,84,182,233,
201,74,31,186,234,144,169,28,204,112,128,62,88,82,137,123,212,106,189,181,126,
202,78,67,50,65,106,217,248,9,226,17,104,240,65,80,143,93,156,167,144,242,140,
20,255,107,152,241,71,183,61,118,145,44,53,50,15,235,41,250,49,164,175,147,118,
239,191,163,216,23,111,13,176,205,39};

static int tmpl_1of7GUIs_fl_size = 763;
static unsigned char tmpl_1of7GUIs_fl[486] = /* data compressed and inlined from templates/1of7GUIs.fl */
{120,156,109,82,203,138,219,64,16,188,207,87,52,228,178,102,177,45,25,59,
187,142,73,14,121,56,187,36,224,92,76,142,102,36,181,164,206,142,102,196,60,252,
88,33,216,223,200,61,127,146,63,201,151,164,37,69,176,9,97,4,163,26,122,170,
170,171,231,5,100,210,75,200,73,33,228,198,130,47,17,182,202,63,192,222,161,133,
123,237,209,230,50,69,120,143,142,10,205,71,87,185,10,148,77,4,28,209,58,50,26,
226,89,180,140,34,1,37,202,12,237,65,203,10,161,153,149,173,72,77,134,35,76,207,
231,86,64,106,170,10,181,135,70,196,96,114,184,249,184,191,119,66,244,27,156,
164,131,4,81,67,106,81,122,204,128,177,4,87,147,158,154,60,239,202,59,107,149,
116,236,232,215,211,119,39,24,58,114,240,206,84,181,180,228,216,9,215,236,146,
111,152,250,233,206,18,235,116,36,58,131,109,208,169,103,167,82,137,47,214,20,
86,86,21,233,162,239,150,149,185,179,35,42,83,247,198,146,11,124,8,5,155,248,
68,142,229,125,167,41,238,66,37,245,180,211,9,126,204,68,246,140,80,88,19,234,
209,219,103,164,68,211,163,216,107,234,179,241,63,127,120,184,147,90,27,134,64,
26,22,81,188,156,9,81,122,95,187,87,243,249,77,17,200,205,10,242,101,72,102,
100,6,60,23,45,52,14,21,119,193,246,73,31,156,9,150,243,215,198,31,24,13,33,139,
86,136,177,43,104,248,130,169,81,119,23,197,86,29,190,146,206,204,169,63,22,74,
38,168,56,162,208,121,134,190,234,124,57,149,208,44,111,95,194,98,189,128,120,
189,132,213,170,5,127,169,121,198,38,36,252,12,44,231,250,40,187,191,35,57,226,
125,100,222,5,207,17,240,20,123,186,195,137,178,2,187,97,14,148,241,10,248,187,
141,96,177,24,102,31,65,243,119,233,244,205,81,170,128,87,209,100,211,114,11,
204,248,54,120,255,167,133,231,94,69,42,149,74,100,250,0,13,241,84,8,94,195,191,
76,52,80,77,54,130,174,175,55,226,255,66,212,9,13,238,214,235,103,238,134,245,
27,226,34,7,2};

void template_install(const char *path, const char *name, const uchar *inSrc, int inSrcLen, int inDstLen) {
  char filename[FL_PATH_MAX];
    strcpy(filename, path);
    strcat(filename, name);
    FILE *f = fopen(filename, "wb");
    if (!f) return;
    uLong dstLen = inDstLen;
    Bytef *dst = (Bytef*)::malloc(inDstLen);
    if (uncompress(dst, &dstLen, (Bytef*)inSrc, (uLong)inSrcLen) != Z_OK) { /* error */ }
    if (fwrite(dst, dstLen, 1, f) <= 0) { /* error */ }
    fclose(f);
}

void template_load() {
  int i;
  char name[1024], filename[1400], path[1024], *ptr;
  struct dirent **files;
  int num_files;

  fluid_prefs.getUserdataPath(path, sizeof(path));
  strlcat(path, "templates", sizeof(path));
  fl_make_path(path);

  int sample_templates_generated = 0;
  fluid_prefs.get("sample_templates_generated", sample_templates_generated, 0);

  if (sample_templates_generated < 2) {
    strcpy(filename, path);
    strcat(filename, "/FLTK_License.fl");
    FILE *f = fopen(filename, "wb");
    if (f) {
      fputs(
  "# data file for the Fltk User Interface Designer (fluid)\nversion 1.0400\nheader_name {.h}\n"
  "code_name {.cxx}\ncomment {//\n// @INSTANCE@ for the Fast Light Tool Kit (FLT"
  "K).\n//\n// Copyright 1998-2023 by Bill Spitzak and others.\n//\n// This library is free sof"
  "tware. Distribution and use rights are outlined in\n// the file \"COPYING\" which should have "
  "been included with this file.  If this\n// file is missing or damaged, see the license at:\n"
  "//\n//     https://www.fltk.org/COPYING.php\n//\n// Please see the following page on how to report "
  "bugs and issues:\n//\n//     https://www.fltk.org/bugs.php\n//\n} {selected in_source in_head"
  "er\n}\n", f);
      fclose(f);
    }

    template_install(path, "/FLTK_License.fl", tmpl_FLTK_License_fl, sizeof(tmpl_FLTK_License_fl), tmpl_FLTK_License_fl_size);
    template_install(path, "/1of7GUIs.fl", tmpl_1of7GUIs_fl, sizeof(tmpl_1of7GUIs_fl), tmpl_1of7GUIs_fl_size);
    sample_templates_generated = 2;
    fluid_prefs.set("sample_templates_generated", sample_templates_generated);
    fluid_prefs.flush();
  }

  num_files = fl_filename_list(path, &files);

  for (i = 0; i < num_files; i ++) {
    if (fl_filename_match(files[i]->d_name, "*.fl")) {
      // Format the name as the filename with "_" replaced with " "
      // and without the trailing ".fl"...
      strlcpy(name, files[i]->d_name, sizeof(name));
      *strstr(name, ".fl") = '\0';

      for (ptr = name; *ptr; ptr ++) {
        if (*ptr == '_') *ptr = ' ';
      }

      // Add the template to the browser...
      snprintf(filename, sizeof(filename), "%s/%s", path, files[i]->d_name);
      template_browser->add(name, fl_strdup(filename));
    }

    free(files[i]);
  }

  if (num_files > 0) free(files);
}
