/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.driver.textui;

import com.sun.msv.driver.textui.Driver;
import com.sun.msv.reader.GrammarReaderController;
import java.io.IOException;
import java.io.PrintStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DebugController
implements GrammarReaderController {
    private boolean displayWarning;
    private boolean warningReported = false;
    public EntityResolver externalEntityResolver;
    protected PrintStream out;

    public DebugController(boolean bl) {
        this(bl, false);
    }

    public DebugController(boolean bl, boolean bl2) {
        this(bl, bl2, System.out);
    }

    public DebugController(boolean bl, boolean bl2, EntityResolver entityResolver) {
        this(bl, bl2, System.out, entityResolver);
    }

    public DebugController(boolean bl, boolean bl2, PrintStream printStream) {
        this(bl, bl2, printStream, null);
    }

    public DebugController(boolean bl, boolean bl2, PrintStream printStream, EntityResolver entityResolver) {
        this.out = printStream;
        this.displayWarning = bl;
        this.warningReported = bl2;
        this.externalEntityResolver = entityResolver;
    }

    public void warning(Locator[] locatorArray, String string) {
        if (!this.displayWarning) {
            if (!this.warningReported) {
                this.out.println(Driver.localize("Driver.WarningFound"));
            }
            this.warningReported = true;
            return;
        }
        this.out.println(string);
        if (locatorArray == null || locatorArray.length == 0) {
            this.out.println("  location unknown");
        } else {
            int n = 0;
            while (n < locatorArray.length) {
                this.printLocation(locatorArray[n]);
                ++n;
            }
        }
    }

    public void error(Locator[] locatorArray, String string, Exception exception) {
        if (exception instanceof SAXException) {
            this.out.println("SAXException: " + exception.getLocalizedMessage());
            SAXException sAXException = (SAXException)exception;
            if (sAXException.getException() != null) {
                this.out.println("  nested exception: " + sAXException.getException().getLocalizedMessage());
                sAXException.getException().printStackTrace(System.out);
            }
        } else {
            this.out.println(string);
            if (exception != null) {
                System.out.println(exception);
            }
        }
        if (locatorArray == null || locatorArray.length == 0) {
            this.out.println("  location unknown");
        } else {
            int n = 0;
            while (n < locatorArray.length) {
                this.printLocation(locatorArray[n]);
                ++n;
            }
        }
    }

    private void printLocation(Locator locator) {
        String string = "";
        if (locator.getColumnNumber() >= 0) {
            string = ":" + locator.getColumnNumber();
        }
        this.out.println("  " + locator.getLineNumber() + string + "@" + locator.getSystemId());
    }

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        if (this.externalEntityResolver != null) {
            return this.externalEntityResolver.resolveEntity(string, string2);
        }
        return null;
    }
}

