#!/usr/bin/perl
use HTMLObject::Template;
my $doc = HTMLObject::Template->new(file => "/var/www/templates/index.html");

$doc->setTitle("Test of HTMLObject::Template");
$doc->printTag(tag => "<BODYTAG>", value => <<"END_OF_BODY");
<center>
<font color="red">
<h1>HTMLObject::Template</h1>
</center>
<br />
This is cool!
<br />Everything in red was just dynamically stuck in this template!</font>
END_OF_BODY

#$doc->setJavascriptVersion("1.6");
$doc->printJavascriptRequired();

#$doc->setFocus("dummy");

my $text = $doc->readTag(tag => "<BODYTAG>");
$doc->deleteTag(tag => "<BODYTAG>");
$doc->printTag(tag => "<BODYTAG>", value => "I just added some more text and flipped things around via read and delete!<br>$text");
#$doc->substitute(tag => "<BODYTAG>", value => $bodyDoc);

$doc->setCookie(name => 'cookie name', value => 'This rocks!');

$doc->javascriptPrint(<<"END_JAVASCRIPT");

function helloWorld()
{
  window.alert("Hello World");
}

END_JAVASCRIPT

# cause the helloWorld function to be called when the page has been
# loaded!
$doc->setOnload(code => "helloWorld();");

$doc->onbeforeunload("return 'testing the onbeforeunload support in your browser.';");

# make the link change the background when you go over it.
my %attributes = ( background => "yellow" );
$doc->setStyleEntry( tag => "a:hover", attributes => \%attributes );

$doc->setLinkDecorations;

# Actually generate the entire document, cookie and all!
$doc->display();
