/*
 * Decompiled with CFR 0.152.
 */
package jwbroek.io;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSelector {
    private static final Logger logger = Logger.getLogger(FileSelector.class.getCanonicalName());
    private static FileFilter dirsFileFilter = new FileFilter(){

        public boolean accept(File file) {
            logger.entering(this.getClass().getCanonicalName(), "accept(File)", file);
            logger.exiting(this.getClass().getCanonicalName(), "accept(File)", file.isDirectory());
            return file.isDirectory();
        }
    };
    private static FileFilter filesFilter = new FileFilter(){

        public boolean accept(File file) {
            logger.entering(this.getClass().getCanonicalName(), "accept(File)", file);
            logger.exiting(this.getClass().getCanonicalName(), "accept(File)", file.isFile());
            return file.isFile();
        }
    };

    private FileSelector() {
        logger.entering(FileSelector.class.getCanonicalName(), "FileSelector(File)");
        logger.warning("jwbroek.io.FileSelector should not be instantiated.");
        logger.exiting(FileSelector.class.getCanonicalName(), "FileSelector(File)");
    }

    public static FileFilter getDirsFilter() {
        logger.entering(FileSelector.class.getCanonicalName(), "getDirsFilter()");
        logger.exiting(FileSelector.class.getCanonicalName(), "getDirsFilter()", dirsFileFilter);
        return dirsFileFilter;
    }

    public static FileFilter getFilesFilter() {
        logger.entering(FileSelector.class.getCanonicalName(), "getFilesFilter()");
        logger.exiting(FileSelector.class.getCanonicalName(), "getFilesFilter()", filesFilter);
        return filesFilter;
    }

    public static FileFilter getPathPatternFilter(final Pattern pattern) {
        logger.entering(FileSelector.class.getCanonicalName(), "getPathPatternFilter(Pattern)", pattern);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                boolean bl;
                logger.entering(this.getClass().getCanonicalName(), "accept(File)", file);
                try {
                    bl = pattern.matcher(file.getCanonicalPath()).matches();
                }
                catch (IOException iOException) {
                    bl = false;
                }
                catch (SecurityException securityException) {
                    bl = false;
                }
                logger.fine("PathPatternFilter " + (bl ? "accepted " : "did not accept '") + file.toString() + "'.");
                logger.exiting(this.getClass().getCanonicalName(), "accept(File)", bl);
                return bl;
            }
        };
        logger.exiting(FileSelector.class.getCanonicalName(), "getPathPatternFilter(Pattern)", fileFilter);
        return fileFilter;
    }

    public static FileFilter getFileNamePatternFilter(final Pattern pattern) {
        logger.entering(FileSelector.class.getCanonicalName(), "getFileNamePatternFilter(Pattern)", pattern);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                boolean bl;
                logger.entering(this.getClass().getCanonicalName(), "accept(File)", file);
                try {
                    bl = pattern.matcher(file.getName()).matches();
                }
                catch (SecurityException securityException) {
                    bl = false;
                }
                logger.fine("FileNamePatternFilter " + (bl ? "accepted " : "did not accept '") + file.toString() + "'.");
                logger.exiting(this.getClass().getCanonicalName(), "accept(File)", bl);
                return bl;
            }
        };
        logger.exiting(FileSelector.class.getCanonicalName(), "getFileNamePatternFilter(Pattern)", fileFilter);
        return fileFilter;
    }

    public static FileFilter getCombinedFileFilter(FileFilter ... fileFilterArray) {
        logger.entering(FileSelector.class.getCanonicalName(), "getCombinedFileFilter(FileFilter[])", fileFilterArray);
        FileFilter fileFilter = FileSelector.getCombinedFileFilter(fileFilterArray);
        logger.exiting(FileSelector.class.getCanonicalName(), "getCombinedFileFilter(FileFilter[])", fileFilter);
        return fileFilter;
    }

    public static FileFilter getCombinedFileFilter(final Iterable<FileFilter> iterable) {
        logger.entering(FileSelector.class.getCanonicalName(), "getCombinedFileFilter(Iterable<FileFilter>)", iterable);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                logger.entering(FileSelector.class.getCanonicalName(), "accept(File)", file);
                boolean bl = true;
                for (FileFilter fileFilter : iterable) {
                    if (fileFilter.accept(file)) continue;
                    bl = false;
                    break;
                }
                logger.fine("CombinedFileFilter " + (bl ? "accepted " : "did not accept '") + file.toString() + "'.");
                logger.exiting(FileSelector.class.getCanonicalName(), "accept(File)", bl);
                return bl;
            }
        };
        logger.exiting(FileSelector.class.getCanonicalName(), "getCombinedFileFilter(Iterable<FileFilter>)", fileFilter);
        return fileFilter;
    }

    public static List<File> selectFiles(File file, Pattern pattern, long l, boolean bl, boolean bl2) {
        logger.entering(FileSelector.class.getCanonicalName(), "selectFiles(File,Pattern,long,boolean,boolean)", new Object[]{file, pattern, l, bl, bl2});
        ArrayList<File> arrayList = new ArrayList<File>();
        FileSelector.selectFiles(file, FileSelector.getPathPatternFilter(pattern), arrayList, l, bl, bl2);
        logger.exiting(FileSelector.class.getCanonicalName(), "selectFiles(File,Pattern,long,boolean,boolean)", arrayList);
        return arrayList;
    }

    public static void selectFiles(File file, FileFilter fileFilter, List<File> list, long l, boolean bl, boolean bl2) {
        block10: {
            block9: {
                logger.entering(FileSelector.class.getCanonicalName(), "selectFiles(File,FileFilter,List<File>,long,boolean,boolean)", new Object[]{file, fileFilter, list, l, bl, bl2});
                if (l < 0L) {
                    logger.exiting(FileSelector.class.getCanonicalName(), "selectFiles(File,FileFilter,List<File>,long,boolean,boolean)");
                    return;
                }
                try {
                    if (bl && fileFilter.accept(file)) {
                        list.add(file);
                    }
                }
                catch (SecurityException securityException) {
                    if (bl2) break block9;
                    logger.throwing(FileSelector.class.getCanonicalName(), "selectFiles(File,FileFilter,List<File>,long,boolean,boolean)", securityException);
                    throw securityException;
                }
            }
            if (file.isDirectory()) {
                try {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null) {
                        long l2 = l == Long.MAX_VALUE ? l : l - 1L;
                        for (File file2 : fileArray) {
                            FileSelector.selectFiles(file2, fileFilter, list, l2, true, bl2);
                        }
                    }
                }
                catch (SecurityException securityException) {
                    if (bl2) break block10;
                    logger.throwing(FileSelector.class.getCanonicalName(), "selectFiles(File,FileFilter,List<File>,long,boolean,boolean)", securityException);
                    throw securityException;
                }
            }
        }
        logger.exiting(FileSelector.class.getCanonicalName(), "selectFiles(File,FileFilter,List<File>,long,boolean,boolean)");
    }
}

