/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.Naming;

public class Record
implements Serializable {
    private Integer type;
    private float mainfloatvalue;
    private float floatvalue1;
    private float floatvalue2;
    private int mainvalue;
    private int reserved1;
    private int reserved2;
    private int reserved3;
    private int imagewidth;
    private int imageheight;
    private int rotationangle;
    private int componentbitdepth;
    private int colorbitdepth;
    private int colorbw;
    private String stringvalue;

    public Record(int n) {
        this.type = new Integer(n);
    }

    public Record(int n, String string) {
        this(n);
        this.stringvalue = string;
    }

    public Record(int n, int n2) {
        this(n);
        this.mainvalue = n2;
    }

    public Record(int n, int n2, float f) {
        this(n, n2);
        this.mainfloatvalue = f;
    }

    public Record(int n, int n2, int n3, int n4) {
        this(n, n2);
        this.reserved1 = n3;
        this.reserved2 = n4;
    }

    public Record(int n, float f) {
        this(n);
        this.mainfloatvalue = f;
    }

    public Record(int n, float f, float f2) {
        this(n, f);
        this.floatvalue1 = f2;
    }

    public Record(int n, float f, float f2, float f3) {
        this(n, f, f2);
        this.floatvalue2 = f3;
    }

    public Record(int n, int n2, int n3, float f, int n4, int n5, int n6, int n7) {
        this(n);
        this.imagewidth = n2;
        this.imageheight = n3;
        this.rotationangle = n4;
        this.mainfloatvalue = f;
        this.componentbitdepth = n5;
        this.colorbitdepth = n6;
        this.colorbw = n7;
    }

    public int getWidth() {
        return this.imagewidth;
    }

    public int getHeight() {
        return this.imageheight;
    }

    public Integer getType() {
        return this.type;
    }

    public String getTypeName() {
        return Naming.getPropName(this.type);
    }

    public float getFloatValue() {
        return this.mainfloatvalue;
    }

    public float getFloatValue(int n) {
        if (n > 1) {
            return this.floatvalue2;
        }
        return this.floatvalue1;
    }

    public int getIntValue() {
        return this.mainvalue;
    }

    public String toString() {
        if (this.stringvalue != null) {
            return this.stringvalue;
        }
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.type) {
            case 6160: {
                stringBuffer.append(this.imagewidth);
                stringBuffer.append("x");
                stringBuffer.append(this.imageheight);
                stringBuffer.append(" Ratio: ");
                stringBuffer.append(this.mainfloatvalue);
                stringBuffer.append(" Rotation: ");
                stringBuffer.append(this.rotationangle);
                stringBuffer.append(" Bit depth: ");
                stringBuffer.append(this.componentbitdepth);
                return stringBuffer.toString();
            }
            case 6168: {
                stringBuffer.append("Compensation: ");
                stringBuffer.append(this.mainfloatvalue);
                stringBuffer.append(" TV: ");
                stringBuffer.append(this.floatvalue1);
                stringBuffer.append(" AV: ");
                stringBuffer.append(this.floatvalue2);
                return stringBuffer.toString();
            }
            case 6151: {
                stringBuffer.append(this.mainfloatvalue);
                return stringBuffer.toString();
            }
            case 6148: {
                stringBuffer.append(this.mainvalue);
                return stringBuffer.toString();
            }
            case 6147: {
                stringBuffer.append("JPEG:");
                switch (this.mainvalue & 0xFFFF) {
                    case 0: {
                        stringBuffer.append("lossy");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("none");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("DCT");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("PS600");
                    }
                }
                return stringBuffer.toString();
            }
            case 4113: {
                stringBuffer.append(this.mainvalue == 0 ? "Shutter" : "Focus");
                return stringBuffer.toString();
            }
            case 4112: {
                stringBuffer.append(this.mainvalue == 0 ? "Single" : "Continuous");
                return stringBuffer.toString();
            }
            case 4106: {
                stringBuffer.append(this.mainvalue == 0 ? "Real-world" : "Written");
                return stringBuffer.toString();
            }
            case 6167: {
                stringBuffer.append(this.mainvalue);
                return stringBuffer.toString();
            }
            case 6163: {
                stringBuffer.append(this.mainfloatvalue);
                return stringBuffer.toString();
            }
            case 6164: {
                stringBuffer.append(this.mainfloatvalue);
                return stringBuffer.toString();
            }
            case 6155: {
                stringBuffer.append(this.mainvalue);
                return stringBuffer.toString();
            }
            case 4124: {
                stringBuffer.append(this.mainvalue);
                return stringBuffer.toString();
            }
            case 6158: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date((long)this.mainvalue * 1000L));
                stringBuffer.append(AbstractImageInfo.dateformat.format(new Date((long)this.mainvalue * 1000L + (long)(-(calendar.get(15) + calendar.get(16))))));
                return stringBuffer.toString();
            }
        }
        return Naming.getPropName(this.type);
    }
}

