/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAMediaSubtitle;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.InputFile;
import net.pms.encoders.FFmpegBase;
import net.pms.encoders.PlayerPurpose;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.formats.Format;
import net.pms.formats.v2.SubtitleUtils;
import net.pms.io.OutputParams;
import net.pms.io.PipeIPCProcess;
import net.pms.io.PipeProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.StreamModifier;
import net.pms.util.PlayerUtil;
import net.pms.util.ProcessUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegVideo
extends FFmpegBase {
    private static final Logger logger = LoggerFactory.getLogger(FFmpegVideo.class);
    private static final String DEFAULT_QSCALE = "3";
    private static final String SUB_DIR = "subs";
    private static PmsConfiguration configuration;
    private boolean dtsRemux;
    private boolean ac3Remux;
    private boolean videoRemux;
    private JCheckBox multiThreadingCheckBox;
    private JCheckBox videoRemuxCheckBox;
    @Deprecated
    public static final String ID = "ffmpegvideo";

    @Deprecated
    public FFmpegVideo() {
        this(PMS.getConfiguration());
    }

    public FFmpegVideo(PmsConfiguration configuration) {
        super(configuration);
        FFmpegVideo.configuration = configuration;
    }

    public List<String> getVideoFilterOptions(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        boolean isResolutionTooHighForRenderer;
        ArrayList<String> options = new ArrayList<String>();
        String subsOption = null;
        String padding = null;
        RendererConfiguration renderer = params.mediaRenderer;
        DLNAMediaSubtitle tempSubs = null;
        if (!this.isDisableSubtitles(params)) {
            tempSubs = this.getSubtitles(params);
        }
        boolean bl = isResolutionTooHighForRenderer = renderer.isVideoRescale() && media != null && media.isMediaparsed() && (media.getWidth() > renderer.getMaxVideoWidth() || media.getHeight() > renderer.getMaxVideoHeight());
        if (tempSubs != null) {
            StringBuilder s = new StringBuilder();
            StringCharacterIterator it = new StringCharacterIterator(ProcessUtil.getShortFileNameIfWideChars(tempSubs.getExternalFile().getAbsolutePath()));
            char ch = it.first();
            while (ch != '\uffff') {
                switch (ch) {
                    case ':': {
                        s.append("\\\\:");
                        break;
                    }
                    case '\\': {
                        s.append("/");
                        break;
                    }
                    case ']': {
                        s.append("\\]");
                        break;
                    }
                    case '[': {
                        s.append("\\[");
                        break;
                    }
                    default: {
                        s.append(ch);
                    }
                }
                ch = it.next();
            }
            String subsFile = s.toString();
            subsFile = subsFile.replace(",", "\\,");
            subsOption = "subtitles=" + subsFile;
        }
        if (renderer.isPadVideoWithBlackBordersTo169AR() && renderer.isRescaleByRenderer()) {
            padding = media != null && media.isMediaparsed() && media.getHeight() != 0 && (double)media.getWidth() / (double)media.getHeight() >= 1.7777777777777777 ? "pad=iw:iw/(16/9):0:(oh-ih)/2" : "pad=ih*(16/9):ih:(ow-iw)/2:0";
        }
        String rescaleSpec = null;
        if (isResolutionTooHighForRenderer || renderer.isPadVideoWithBlackBordersTo169AR() && !renderer.isRescaleByRenderer()) {
            rescaleSpec = String.format("scale=iw*min(%1$d/iw\\,%2$d/ih):ih*min(%1$d/iw\\,%2$d/ih),pad=%1$d:%2$d:(%1$d-iw)/2:(%2$d-ih)/2", renderer.getMaxVideoWidth(), renderer.getMaxVideoHeight());
        }
        String overrideVF = renderer.getFFmpegVideoFilterOverride();
        if (rescaleSpec != null || padding != null || overrideVF != null || subsOption != null) {
            options.add("-vf");
            StringBuilder filterParams = new StringBuilder();
            if (overrideVF != null) {
                filterParams.append(overrideVF);
                if (subsOption != null) {
                    filterParams.append(", ");
                }
            } else {
                if (rescaleSpec != null) {
                    filterParams.append(rescaleSpec);
                    if (subsOption != null || padding != null) {
                        filterParams.append(", ");
                    }
                }
                if (padding != null && rescaleSpec == null) {
                    filterParams.append(padding);
                    if (subsOption != null) {
                        filterParams.append(", ");
                    }
                }
            }
            if (subsOption != null) {
                filterParams.append(subsOption);
            }
            options.add(filterParams.toString());
        }
        return options;
    }

    public synchronized List<String> getVideoTranscodeOptions(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) {
        ArrayList<String> options = new ArrayList<String>();
        String filename = dlna.getSystemName();
        RendererConfiguration renderer = params.mediaRenderer;
        if (renderer.isTranscodeToWMV() && !renderer.isXBOX()) {
            options.add("-c:v");
            options.add("wmv2");
            options.add("-c:a");
            options.add("wmav2");
            options.add("-f");
            options.add("asf");
        } else {
            if (this.isAc3Remux()) {
                options.add("-c:a");
                options.add("copy");
            } else if (this.isDtsRemux()) {
                options.add("-an");
            } else if (this.type() != 1) {
                options.add("-c:a");
                options.add("ac3");
            }
            InputFile newInput = null;
            if (filename != null) {
                newInput = new InputFile();
                newInput.setFilename(filename);
                newInput.setPush(params.stdin);
            }
            if (media.isMediaparsed() && params.sid == null && (newInput != null && media.isVideoWithinH264LevelLimits(newInput, params.mediaRenderer) || !params.mediaRenderer.isH264Level41Limited()) && media.isMuxable(params.mediaRenderer) && configuration.isFFmpegMuxWhenCompatible() && params.mediaRenderer.isMuxH264MpegTS()) {
                options.add("-c:v");
                options.add("copy");
                options.add("-bsf");
                options.add("h264_mp4toannexb");
                options.add("-fflags");
                options.add("+genpts");
                this.setVideoRemux(true);
            } else if (renderer.isTranscodeToH264TSAC3()) {
                options.add("-c:v");
                options.add("libx264");
                options.add("-crf");
                options.add("20");
                options.add("-preset");
                options.add("superfast");
            } else if (!this.isDtsRemux()) {
                options.add("-c:v");
                options.add("mpeg2video");
            }
            options.add("-f");
            if (this.isDtsRemux()) {
                if (this.isVideoRemux()) {
                    options.add("rawvideo");
                } else {
                    options.add("mpeg2video");
                }
            } else if (renderer.isTranscodeToMPEGTSAC3() || renderer.isTranscodeToH264TSAC3() || this.isVideoRemux()) {
                options.add("mpegts");
            } else {
                options.add("vob");
            }
        }
        return options;
    }

    public List<String> getVideoBitrateOptions(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) {
        ArrayList<String> options = new ArrayList<String>();
        String sMaxVideoBitrate = params.mediaRenderer.getMaxVideoBitrate();
        int iMaxVideoBitrate = 0;
        if (sMaxVideoBitrate != null) {
            try {
                iMaxVideoBitrate = Integer.parseInt(sMaxVideoBitrate);
            }
            catch (NumberFormatException nfe) {
                logger.error("Can't parse max video bitrate", nfe);
            }
        }
        if (iMaxVideoBitrate == 0) {
            options.add("-q:v");
            options.add(DEFAULT_QSCALE);
        } else {
            options.add("-maxrate");
            options.add("" + iMaxVideoBitrate * 1000 * 1000);
        }
        return options;
    }

    public List<String> getAudioBitrateOptions(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-q:a");
        options.add(DEFAULT_QSCALE);
        return options;
    }

    public List<String> getAudioChannelOptions(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) {
        int nChannels;
        ArrayList<String> options = new ArrayList<String>();
        int ac = -1;
        int n = nChannels = params.aid == null ? -1 : params.aid.getAudioProperties().getNumberOfChannels();
        if (nChannels == -1) {
            ac = 2;
        } else if (nChannels > 2) {
            int maxOutputChannels = configuration.getAudioChannelCount();
            if (maxOutputChannels <= 2) {
                ac = maxOutputChannels;
            } else if (params.mediaRenderer.isTranscodeToWMV()) {
                ac = 2;
            }
        }
        if (ac != -1) {
            options.add("-ac");
            options.add("" + ac);
        }
        return options;
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.VIDEO_FILE_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    public String initialString() {
        String threads = "";
        if (configuration.isFfmpegMultithreading()) {
            threads = " -threads " + configuration.getNumberOfCpuCores();
        }
        return threads;
    }

    @Override
    public String name() {
        return "FFmpeg";
    }

    @Override
    public int type() {
        return 4;
    }

    @Deprecated
    protected String[] getDefaultArgs() {
        ArrayList<String> defaultArgsList = new ArrayList<String>();
        defaultArgsList.add("-loglevel");
        defaultArgsList.add("warning");
        String[] defaultArgsArray = new String[defaultArgsList.size()];
        defaultArgsList.toArray(defaultArgsArray);
        return defaultArgsArray;
    }

    private int[] getVideoBitrateConfig(String bitrate) {
        int[] bitrates = new int[2];
        if (bitrate.contains("(") && bitrate.contains(")")) {
            bitrates[1] = Integer.parseInt(bitrate.substring(bitrate.indexOf("(") + 1, bitrate.indexOf(")")));
        }
        if (bitrate.contains("(")) {
            bitrate = bitrate.substring(0, bitrate.indexOf("(")).trim();
        }
        if (StringUtils.isBlank(bitrate)) {
            bitrate = "0";
        }
        bitrates[0] = (int)Double.parseDouble(bitrate);
        return bitrates;
    }

    @Override
    @Deprecated
    public String[] args() {
        return this.getDefaultArgs();
    }

    @Override
    public String mimeType() {
        return "video/transcode";
    }

    @Override
    public synchronized ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        int nThreads = configuration.getNumberOfCpuCores();
        ArrayList<String> cmdList = new ArrayList<String>();
        RendererConfiguration renderer = params.mediaRenderer;
        String filename = dlna.getSystemName();
        this.setAudioAndSubs(filename, media, params, configuration);
        params.waitbeforestart = 2500;
        cmdList.add(this.executable());
        cmdList.addAll(this.getGlobalOptions(logger));
        if (params.timeseek > 0.0) {
            cmdList.add("-ss");
            cmdList.add("" + params.timeseek);
        }
        cmdList.add("-threads");
        cmdList.add("" + nThreads);
        boolean isTsMuxeRVideoEngineEnabled = configuration.getEnginesAsList().contains("tsmuxer");
        this.setAc3Remux(false);
        this.setDtsRemux(false);
        this.setVideoRemux(false);
        if (configuration.isAudioRemuxAC3() && params.aid != null && params.aid.isAC3() && renderer.isTranscodeToAC3()) {
            this.setAc3Remux(true);
        } else if (isTsMuxeRVideoEngineEnabled && configuration.isAudioEmbedDtsInPcm() && params.aid != null && params.aid.isDTS() && params.mediaRenderer.isDTSPlayable()) {
            this.setDtsRemux(true);
        }
        String frameRateRatio = media.getValidFps(true);
        String frameRateNumber = media.getValidFps(false);
        cmdList.add("-i");
        cmdList.add(filename);
        if (media.getAudioTracksList().size() > 1) {
            cmdList.add("-map");
            cmdList.add("0:v");
            cmdList.add("-map");
            cmdList.add("0:a:" + media.getAudioTracksList().indexOf(params.aid));
        }
        cmdList.add("-threads");
        cmdList.add("" + nThreads);
        if (params.timeend > 0.0) {
            cmdList.add("-t");
            cmdList.add("" + params.timeend);
        }
        cmdList.addAll(this.getVideoFilterOptions(dlna, media, params));
        int[] defaultMaxBitrates = this.getVideoBitrateConfig(configuration.getMaximumBitrate());
        int[] rendererMaxBitrates = new int[2];
        if (renderer.getMaxVideoBitrate() != null) {
            rendererMaxBitrates = this.getVideoBitrateConfig(renderer.getMaxVideoBitrate());
        }
        if (rendererMaxBitrates[0] > 0 && rendererMaxBitrates[0] < defaultMaxBitrates[0]) {
            defaultMaxBitrates = rendererMaxBitrates;
        }
        if (params.mediaRenderer.getCBRVideoBitrate() == 0) {
            defaultMaxBitrates[0] = 1000 * defaultMaxBitrates[0];
            defaultMaxBitrates[0] = defaultMaxBitrates[0] / 2;
            int bufSize = 1835;
            if (!renderer.isTranscodeToH264TSAC3()) {
                if (media.isHDVideo()) {
                    bufSize = defaultMaxBitrates[0] / 3;
                }
                if (bufSize > 7000) {
                    bufSize = 7000;
                }
                if (defaultMaxBitrates[1] > 0) {
                    bufSize = defaultMaxBitrates[1];
                }
                if (params.mediaRenderer.isDefaultVBVSize() && rendererMaxBitrates[1] == 0) {
                    bufSize = 1835;
                }
            }
            defaultMaxBitrates[0] = this.isDtsRemux() ? defaultMaxBitrates[0] - 1510 : defaultMaxBitrates[0] - configuration.getAudioBitrate();
            defaultMaxBitrates[0] = defaultMaxBitrates[0] / 1000 * 1000;
            bufSize *= 1000;
            defaultMaxBitrates[0] = defaultMaxBitrates[0] * 1000;
            if (renderer.isTranscodeToH264TSAC3() || this.isVideoRemux()) {
                if (params.mediaRenderer.isH264Level41Limited() && defaultMaxBitrates[0] > 31250000) {
                    defaultMaxBitrates[0] = 31250000;
                }
                bufSize = defaultMaxBitrates[0];
            }
            cmdList.add("-bufsize");
            cmdList.add("" + bufSize);
            cmdList.add("-maxrate");
            cmdList.add("" + defaultMaxBitrates[0]);
        }
        if (!this.isAc3Remux() && !this.isDtsRemux() && this.type() != 1) {
            int channels = renderer.isTranscodeToWMV() && !renderer.isXBOX() ? 2 : configuration.getAudioChannelCount();
            cmdList.add("-ac");
            cmdList.add("" + channels);
            cmdList.add("-ab");
            cmdList.add(configuration.getAudioBitrate() + "k");
        }
        if (params.timeseek > 0.0) {
            cmdList.add("-copypriorss");
            cmdList.add("0");
            cmdList.add("-avoid_negative_ts");
            cmdList.add("1");
        }
        if (!renderer.isTranscodeToH264TSAC3() && !this.isVideoRemux()) {
            String mpeg2Options = configuration.getMPEG2MainSettingsFFmpeg();
            String mpeg2OptionsRenderer = params.mediaRenderer.getCustomFFmpegMPEG2Options();
            if (StringUtils.isNotBlank(mpeg2OptionsRenderer)) {
                mpeg2Options = mpeg2OptionsRenderer;
            } else if (mpeg2Options.contains("Automatic")) {
                mpeg2Options = "-g 5 -q:v 1 -qmin 2 -qmax 3";
                if (params.mediaRenderer.isPS3()) {
                    mpeg2Options = "-g 25 -q:v 1 -qmin 2 -qmax 3";
                }
                if (mpeg2Options.contains("Wireless") || defaultMaxBitrates[0] < 70) {
                    if (media.getWidth() > 1280) {
                        mpeg2Options = "-g 25 -qmax 7 -qmin 2";
                    } else if (media.getWidth() > 720) {
                        mpeg2Options = "-g 25 -qmax 5 -qmin 2";
                    }
                }
            }
            String[] customOptions = StringUtils.split(mpeg2Options);
            cmdList.addAll(new ArrayList<String>(Arrays.asList(customOptions)));
        }
        cmdList.addAll(this.getVideoTranscodeOptions(dlna, media, params));
        if (StringUtils.isNotEmpty(renderer.getCustomFFmpegOptions())) {
            FFmpegVideo.parseOptions(renderer.getCustomFFmpegOptions(), cmdList);
        }
        if (!this.isDtsRemux()) {
            cmdList.add("pipe:");
        }
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        if (this.isDtsRemux()) {
            PipeProcess pipe = new PipeProcess(System.currentTimeMillis() + "tsmuxerout.ts", new String[0]);
            TsMuxeRVideo ts = new TsMuxeRVideo(configuration);
            File f = new File(configuration.getTempFolder(), "pms-tsmuxer.meta");
            String[] cmd = new String[]{ts.executable(), f.getAbsolutePath(), pipe.getInputPipe()};
            pw = new ProcessWrapperImpl(cmd, params);
            PipeIPCProcess ffVideoPipe = new PipeIPCProcess(System.currentTimeMillis() + ID, System.currentTimeMillis() + "videoout", false, true);
            cmdList.add(ffVideoPipe.getInputPipe());
            OutputParams ffparams = new OutputParams(configuration);
            ffparams.maxBufferSize = 1.0;
            ffparams.stdin = params.stdin;
            String[] cmdArrayDts = new String[cmdList.size()];
            cmdList.toArray(cmdArrayDts);
            cmdArrayDts = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArrayDts);
            ProcessWrapperImpl ffVideo = new ProcessWrapperImpl(cmdArrayDts, ffparams);
            ProcessWrapper ff_video_pipe_process = ffVideoPipe.getPipeProcess();
            pw.attachProcess(ff_video_pipe_process);
            ff_video_pipe_process.runInNewThread();
            ffVideoPipe.deleteLater();
            pw.attachProcess(ffVideo);
            ffVideo.runInNewThread();
            PipeIPCProcess ffAudioPipe = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegaudio01", System.currentTimeMillis() + "audioout", false, true);
            StreamModifier sm = new StreamModifier();
            sm.setPcm(false);
            sm.setDtsEmbed(this.isDtsRemux());
            sm.setSampleFrequency(48000);
            sm.setBitsPerSample(16);
            sm.setNbChannels(2);
            ArrayList<String> cmdListDTS = new ArrayList<String>();
            cmdListDTS.add(this.executable());
            cmdListDTS.add("-y");
            cmdListDTS.add("-ss");
            if (params.timeseek > 0.0) {
                cmdListDTS.add("" + params.timeseek);
            } else {
                cmdListDTS.add("0");
            }
            if (params.stdin == null) {
                cmdListDTS.add("-i");
            } else {
                cmdListDTS.add("-");
            }
            cmdListDTS.add(filename);
            if (params.timeseek > 0.0) {
                cmdListDTS.add("-copypriorss");
                cmdListDTS.add("0");
                cmdListDTS.add("-avoid_negative_ts");
                cmdListDTS.add("1");
            }
            cmdListDTS.add("-ac");
            cmdListDTS.add("2");
            cmdListDTS.add("-f");
            cmdListDTS.add("dts");
            cmdListDTS.add("-c:a");
            cmdListDTS.add("copy");
            cmdListDTS.add(ffAudioPipe.getInputPipe());
            String[] cmdArrayDTS = new String[cmdListDTS.size()];
            cmdListDTS.toArray(cmdArrayDTS);
            if (!params.mediaRenderer.isMuxDTSToMpeg()) {
                ffAudioPipe.setModifier(sm);
            }
            OutputParams ffaudioparams = new OutputParams(configuration);
            ffaudioparams.maxBufferSize = 1.0;
            ffaudioparams.stdin = params.stdin;
            ProcessWrapperImpl ffAudio = new ProcessWrapperImpl(cmdArrayDTS, ffaudioparams);
            params.stdin = null;
            PrintWriter pwMux = new PrintWriter(f);
            pwMux.println("MUXOPT --no-pcr-on-video-pid --no-asyncio --new-audio-pes --vbr --vbv-len=500");
            String videoType = "V_MPEG-2";
            if (this.isVideoRemux()) {
                videoType = "V_MPEG4/ISO/AVC";
            }
            if (params.no_videoencode && params.forceType != null) {
                videoType = params.forceType;
            }
            String fps = "";
            if (params.forceFps != null) {
                fps = "fps=" + params.forceFps + ", ";
            }
            String audioType = "A_AC3";
            if (this.isDtsRemux()) {
                audioType = params.mediaRenderer.isMuxDTSToMpeg() ? "A_DTS" : "A_LPCM";
            }
            pwMux.println(videoType + ", \"" + ffVideoPipe.getOutputPipe() + "\", " + fps + "level=4.1, insertSEI, contSPS, track=1");
            pwMux.println(audioType + ", \"" + ffAudioPipe.getOutputPipe() + "\", track=2");
            pwMux.close();
            ProcessWrapper pipe_process = pipe.getPipeProcess();
            pw.attachProcess(pipe_process);
            pipe_process.runInNewThread();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            pipe.deleteLater();
            params.input_pipes[0] = pipe;
            ProcessWrapper ff_pipe_process = ffAudioPipe.getPipeProcess();
            pw.attachProcess(ff_pipe_process);
            ff_pipe_process.runInNewThread();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ffAudioPipe.deleteLater();
            pw.attachProcess(ffAudio);
            ffAudio.runInNewThread();
        }
        pw.runInNewThread();
        return pw;
    }

    @Override
    public JComponent config() {
        return this.config("NetworkTab.5");
    }

    protected JComponent config(String languageLabel) {
        FormLayout layout = new FormLayout("left:pref, 0:grow", "p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.EMPTY_BORDER);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        JComponent cmp = builder.addSeparator(Messages.getString(languageLabel), cc.xyw(2, 1, 1));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        this.multiThreadingCheckBox = new JCheckBox(Messages.getString("MEncoderVideo.35"));
        this.multiThreadingCheckBox.setContentAreaFilled(false);
        if (configuration.isFfmpegMultithreading()) {
            this.multiThreadingCheckBox.setSelected(true);
        }
        this.multiThreadingCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                configuration.setFfmpegMultithreading(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.multiThreadingCheckBox, cc.xy(2, 3));
        this.videoRemuxCheckBox = new JCheckBox(Messages.getString("FFmpeg.0"));
        this.videoRemuxCheckBox.setContentAreaFilled(false);
        if (configuration.isFFmpegMuxWhenCompatible()) {
            this.videoRemuxCheckBox.setSelected(true);
        }
        this.videoRemuxCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                configuration.setFFmpegMuxWhenCompatible(e.getStateChange() == 1);
            }
        });
        builder.add((Component)this.videoRemuxCheckBox, cc.xy(2, 5));
        return builder.getPanel();
    }

    @Override
    public boolean isCompatible(DLNAResource dlna) {
        return PlayerUtil.isVideo(dlna, Format.Identifier.MKV) || PlayerUtil.isVideo(dlna, Format.Identifier.MPG);
    }

    protected static List<String> parseOptions(String str) {
        return str == null ? null : FFmpegVideo.parseOptions(str, new ArrayList<String>());
    }

    protected static List<String> parseOptions(String str, List<String> cmdList) {
        while (str.length() > 0) {
            String tmp;
            int pos;
            if (str.charAt(0) == '\"') {
                pos = str.indexOf("\"", 1);
                if (pos == -1) break;
                tmp = str.substring(1, pos);
                cmdList.add(tmp.trim());
                str = str.substring(pos + 1);
                continue;
            }
            pos = str.indexOf(" ");
            if (pos == -1) {
                cmdList.add(str);
                break;
            }
            tmp = str.substring(0, pos);
            cmdList.add(tmp.trim());
            str = str.substring(pos + 1);
        }
        return cmdList;
    }

    public DLNAMediaSubtitle getSubtitles(OutputParams params) throws IOException {
        DLNAMediaSubtitle tempSubs = null;
        if (params.sid.getId() == -1) {
            return null;
        }
        File subtitleDirectory = new File(configuration.getTempFolder(), SUB_DIR + File.separator);
        if (!subtitleDirectory.exists()) {
            subtitleDirectory.mkdirs();
        }
        if (params.sid.isExternal() && SubtitleUtils.isSupportsTimeShifting(params.sid.getType())) {
            try {
                tempSubs = SubtitleUtils.shiftSubtitlesTimingWithUtfConversion(params.sid, params.timeseek);
            }
            catch (IOException e) {
                logger.debug("Applying timeshift caused an error: " + e);
                tempSubs = null;
            }
        }
        return tempSubs;
    }

    private File extractEmbeddedSubtitleTrack(String filename, DLNAMediaInfo media, OutputParams params) throws IOException {
        File subtitleDirectory;
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(configuration.getFfmpegPath());
        cmdList.addAll(this.getGlobalOptions(logger));
        cmdList.add("-i");
        cmdList.add(filename);
        if (params.sid.isEmbedded()) {
            cmdList.add("-map");
            cmdList.add("0:" + (params.sid.getId() + media.getAudioTracksList().size() + 1));
        }
        if (!(subtitleDirectory = new File(configuration.getTempFolder(), SUB_DIR + File.separator)).exists()) {
            subtitleDirectory.mkdirs();
        }
        File tempSubsFile = params.sid.isEmbedded() ? new File(subtitleDirectory.getAbsolutePath() + File.separator + FilenameUtils.getBaseName(new File(filename).getName()).replaceAll("\\W", "_") + "_" + new File(filename).length() + "_EMB_ID" + params.sid.getId() + ".ass") : new File(subtitleDirectory.getAbsolutePath() + File.separator + FilenameUtils.getBaseName(new File(filename).getName()).replaceAll("\\W", "_") + "_" + new File(filename).length() + "_EXT." + FilenameUtils.getExtension(new File(filename).getName()));
        cmdList.add(tempSubsFile.getAbsolutePath());
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.runInNewThread();
        try {
            pw.join();
        }
        catch (InterruptedException e) {
            logger.debug("Subtitle conversion finished wih error: " + e);
            return null;
        }
        return tempSubsFile;
    }

    public boolean isDisableSubtitles(OutputParams params) {
        return configuration.isDisableSubtitles() || params.sid == null;
    }

    private synchronized boolean isAc3Remux() {
        return this.ac3Remux;
    }

    private synchronized void setAc3Remux(boolean ac3Remux) {
        this.ac3Remux = ac3Remux;
    }

    private synchronized boolean isDtsRemux() {
        return this.dtsRemux;
    }

    private synchronized void setDtsRemux(boolean dtsRemux) {
        this.dtsRemux = dtsRemux;
    }

    private synchronized boolean isVideoRemux() {
        return this.videoRemux;
    }

    private synchronized void setVideoRemux(boolean videoRemux) {
        this.videoRemux = videoRemux;
    }
}

