/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JComponent;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.Player;
import net.pms.encoders.PlayerPurpose;
import net.pms.formats.Format;
import net.pms.io.InternalJavaProcessImpl;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.PlayerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAWThumbnailer
extends Player {
    private static final Logger logger = LoggerFactory.getLogger(RAWThumbnailer.class);
    private final PmsConfiguration configuration;
    public static final String ID = "rawthumbs";

    public RAWThumbnailer(PmsConfiguration configuration) {
        this.configuration = configuration;
    }

    protected String[] getDefaultArgs() {
        return new String[]{"-e", "-c"};
    }

    @Override
    public String[] args() {
        return this.getDefaultArgs();
    }

    @Override
    public JComponent config() {
        return null;
    }

    @Override
    public String executable() {
        return this.configuration.getDCRawPath();
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        params.waitbeforestart = 1;
        params.minBufferSize = 1.0;
        params.maxBufferSize = 5.0;
        params.hidebuffer = true;
        String filename = dlna.getSystemName();
        if (media == null || media.getThumb() == null) {
            return null;
        }
        if (media.getThumb().length == 0) {
            try {
                media.setThumb(RAWThumbnailer.getThumbnail(params, filename));
            }
            catch (Exception e) {
                logger.error("error extracting thumbnail", e);
                return null;
            }
        }
        byte[] copy = new byte[media.getThumb().length];
        System.arraycopy(media.getThumb(), 0, copy, 0, media.getThumb().length);
        media.setThumb(new byte[0]);
        InternalJavaProcessImpl pw = new InternalJavaProcessImpl(new ByteArrayInputStream(copy));
        return pw;
    }

    @Override
    public String mimeType() {
        return "image/jpeg";
    }

    @Override
    public String name() {
        return "dcraw Thumbnailer";
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.MISC_PLAYER;
    }

    @Override
    public int type() {
        return 2;
    }

    public static byte[] getThumbnail(OutputParams params, String fileName) throws Exception {
        params.log = false;
        String[] cmdArray = new String[]{PMS.getConfiguration().getDCRawPath(), "-e", "-c", fileName};
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.runInSameThread();
        InputStream is = pw.getInputStream(0L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int n = -1;
        byte[] buffer = new byte[4096];
        while ((n = is.read(buffer)) > -1) {
            baos.write(buffer, 0, n);
        }
        is.close();
        byte[] b = baos.toByteArray();
        baos.close();
        return b;
    }

    @Override
    public boolean isCompatible(DLNAResource resource) {
        return PlayerUtil.isImage(resource, Format.Identifier.RAW);
    }
}

