/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.io.BasicSystemUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacSystemUtils
extends BasicSystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(MacSystemUtils.class);

    @Override
    public void browseURI(String uri) {
        try {
            Runtime.getRuntime().exec(new String[]{"open", uri});
        }
        catch (IOException e) {
            logger.trace("Unable to open the given URI: {}", (Object)uri);
        }
    }

    @Override
    public boolean isNetworkInterfaceLoopback(NetworkInterface ni) throws SocketException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getHardwareAddress(NetworkInterface ni) throws SocketException {
        byte[] aHardwareAddress = null;
        InputStream inputStream = null;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"ifconfig", ni.getName(), "ether"});
            inputStream = process.getInputStream();
            List<String> lines = IOUtils.readLines(inputStream);
            String aMacStr = null;
            Pattern aMacPattern = Pattern.compile("\\s*ether\\s*([a-d0-9]{2}:[a-d0-9]{2}:[a-d0-9]{2}:[a-d0-9]{2}:[a-d0-9]{2}:[a-d0-9]{2})");
            for (String line : lines) {
                Matcher aMacMatcher = aMacPattern.matcher(line);
                if (!aMacMatcher.find()) continue;
                aMacStr = aMacMatcher.group(1);
                break;
            }
            if (aMacStr != null) {
                String[] aComps = aMacStr.split(":");
                aHardwareAddress = new byte[aComps.length];
                for (int i = 0; i < aComps.length; ++i) {
                    String aComp = aComps[i];
                    aHardwareAddress[i] = (byte)Short.valueOf(aComp, 16).shortValue();
                }
            }
            IOUtils.closeQuietly(inputStream);
        }
        catch (IOException e) {
            logger.warn("Failed to execute ifconfig", e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return aHardwareAddress;
    }
}

