/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.pms.PMS;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedStats {
    private static SpeedStats instance = new SpeedStats();
    private static ExecutorService executor = Executors.newCachedThreadPool();
    private static final Logger logger = LoggerFactory.getLogger(SpeedStats.class);
    private final Map<String, Future<Integer>> speedStats = new HashMap<String, Future<Integer>>();

    public static SpeedStats getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Integer> getSpeedInMBits(InetAddress addr, String rendererName) {
        Map<String, Future<Integer>> map = this.speedStats;
        synchronized (map) {
            Future<Integer> value = this.speedStats.get(addr.getHostAddress());
            if (value != null) {
                return value;
            }
            value = executor.submit(new MeasureSpeed(addr, rendererName));
            this.speedStats.put(addr.getHostAddress(), value);
            return value;
        }
    }

    static class CompletedFuture<X>
    implements Future<X> {
        X value;

        public CompletedFuture(X value) {
            this.value = value;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public X get() throws InterruptedException, ExecutionException {
            return this.value;
        }

        @Override
        public X get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.value;
        }
    }

    class MeasureSpeed
    implements Callable<Integer> {
        InetAddress addr;
        String rendererName;

        public MeasureSpeed(InetAddress addr, String rendererName) {
            this.addr = addr;
            this.rendererName = rendererName != null ? rendererName : "Unknown";
        }

        @Override
        public Integer call() throws Exception {
            try {
                return this.doCall();
            }
            catch (Exception e) {
                logger.warn("Error measuring network throughput : " + e.getMessage(), e);
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer doCall() throws Exception {
            String ip = this.addr.getHostAddress();
            logger.info("Checking IP: " + ip + " for " + this.rendererName);
            String hostname = this.addr.getCanonicalHostName();
            Map map = SpeedStats.this.speedStats;
            synchronized (map) {
                Future otherTask = (Future)SpeedStats.this.speedStats.get(hostname);
                if (otherTask != null) {
                    try {
                        Integer value = (Integer)otherTask.get(100L, TimeUnit.MILLISECONDS);
                        if (value != null) {
                            return value;
                        }
                    }
                    catch (TimeoutException e) {
                        logger.trace("We couldn't get the value based on the canonical name");
                    }
                }
            }
            if (!ip.equals(hostname)) {
                logger.info("Renderer " + this.rendererName + " found on this address: " + hostname + " (" + ip + ")");
            } else {
                logger.info("Renderer " + this.rendererName + " found on this address: " + ip);
            }
            OutputParams op = new OutputParams(null);
            op.log = true;
            op.maxBufferSize = 1.0;
            SystemUtils sysUtil = PMS.get().getRegistry();
            final ProcessWrapperImpl pw = new ProcessWrapperImpl(sysUtil.getPingCommand(this.addr.getHostAddress(), 3, 64000), op, true, false);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    pw.stopProcess();
                }
            };
            Thread failsafe = new Thread(r, "SpeedStats Failsafe");
            failsafe.start();
            pw.runInSameThread();
            List<String> ls = pw.getOtherResults();
            int time = 0;
            int c = 0;
            for (String line : ls) {
                int msPos = line.indexOf("ms");
                if (msPos <= -1) continue;
                String timeString = line.substring(line.lastIndexOf("=", msPos) + 1, msPos).trim();
                try {
                    time = (int)((double)time + Double.parseDouble(timeString));
                    ++c;
                }
                catch (NumberFormatException e) {
                    logger.debug("Could not parse time from \"" + timeString + "\"");
                }
            }
            if (c > 0) {
                time /= c;
            }
            if (time > 0) {
                int speedInMbits = 1024 / time;
                logger.info("Address " + this.addr + " has an estimated network speed of: " + speedInMbits + " Mb/s");
                Map map2 = SpeedStats.this.speedStats;
                synchronized (map2) {
                    CompletedFuture<Integer> result = new CompletedFuture<Integer>(speedInMbits);
                    SpeedStats.this.speedStats.put(ip, result);
                    SpeedStats.this.speedStats.put(hostname, result);
                }
                return speedInMbits;
            }
            return -1;
        }
    }
}

