/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.logging.Logger;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.TagOptionSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataDescriptor
implements Comparable<MetadataDescriptor>,
Cloneable {
    public static final long DWORD_MAXVALUE = new BigInteger("FFFFFFFF", 16).longValue();
    private static final Logger LOGGER = Logger.getLogger("org.jaudiotagger.audio.asf.data");
    public static final int MAX_LANG_INDEX = 127;
    public static final int MAX_STREAM_NUMBER = 127;
    public static final BigInteger QWORD_MAXVALUE = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    public static final int TYPE_BINARY = 1;
    public static final int TYPE_BOOLEAN = 2;
    public static final int TYPE_DWORD = 3;
    public static final int TYPE_GUID = 6;
    public static final int TYPE_QWORD = 4;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_WORD = 5;
    public static final int WORD_MAXVALUE = 65535;
    private final ContainerType containerType;
    private byte[] content = new byte[0];
    private int descriptorType;
    private int languageIndex = 0;
    private final String name;
    private int streamNumber = 0;

    public MetadataDescriptor(ContainerType type, String propName, int propType) {
        this(type, propName, propType, 0, 0);
    }

    public MetadataDescriptor(ContainerType type, String propName, int propType, int stream, int language) {
        assert (type != null);
        type.assertConstraints(propName, new byte[0], propType, stream, language);
        this.containerType = type;
        this.name = propName;
        this.descriptorType = propType;
        this.streamNumber = stream;
        this.languageIndex = language;
    }

    public MetadataDescriptor(String propName) {
        this(propName, 0);
    }

    public MetadataDescriptor(String propName, int propType) {
        this(ContainerType.METADATA_LIBRARY_OBJECT, propName, propType, 0, 0);
    }

    public BigInteger asNumber() {
        BigInteger result = null;
        switch (this.descriptorType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (this.content.length <= 8) break;
                throw new NumberFormatException("Binary data would exceed QWORD");
            }
            case 6: {
                throw new NumberFormatException("GUID cannot be converted to a number.");
            }
            case 0: {
                result = new BigInteger(this.getString(), 10);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (result == null) {
            byte[] copy = new byte[this.content.length];
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = this.content[this.content.length - (i + 1)];
            }
            result = new BigInteger(1, copy);
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public int compareTo(MetadataDescriptor other) {
        return this.getName().compareTo(other.getName());
    }

    public MetadataDescriptor createCopy() {
        MetadataDescriptor result = new MetadataDescriptor(this.containerType, this.name, this.descriptorType, this.streamNumber, this.languageIndex);
        result.content = this.getRawData();
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof MetadataDescriptor) {
            MetadataDescriptor other;
            result = obj == this ? true : (other = (MetadataDescriptor)obj).getName().equals(this.getName()) && other.descriptorType == this.descriptorType && other.languageIndex == this.languageIndex && other.streamNumber == this.streamNumber && Arrays.equals(this.content, other.content);
        }
        return result;
    }

    public boolean getBoolean() {
        return this.content.length > 0 && this.content[0] != 0;
    }

    @Deprecated
    public byte[] getBytes() {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            this.writeInto(result, this.containerType);
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
        return result.toByteArray();
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public int getCurrentAsfSize(ContainerType type) {
        int result = 8;
        if (type != ContainerType.EXTENDED_CONTENT) {
            result += 6;
        }
        result += this.getName().length() * 2;
        if (this.getType() == 2) {
            result += 2;
            if (type == ContainerType.EXTENDED_CONTENT) {
                result += 2;
            }
        } else {
            result += this.content.length;
            if (0 == this.getType()) {
                result += 2;
            }
        }
        return result;
    }

    public GUID getGuid() {
        GUID result = null;
        if (this.getType() == 6 && this.content.length == 16) {
            result = new GUID(this.content);
        }
        return result;
    }

    public int getLanguageIndex() {
        return this.languageIndex;
    }

    public String getName() {
        return this.name;
    }

    public long getNumber() {
        int bytesNeeded;
        switch (this.getType()) {
            case 2: {
                bytesNeeded = 1;
                break;
            }
            case 3: {
                bytesNeeded = 4;
                break;
            }
            case 4: {
                bytesNeeded = 8;
                break;
            }
            case 5: {
                bytesNeeded = 2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The current type doesn't allow an interpretation as a number. (" + this.getType() + ")");
            }
        }
        if (bytesNeeded > this.content.length) {
            throw new IllegalStateException("The stored data cannot represent the type of current object.");
        }
        long result = 0L;
        for (int i = 0; i < bytesNeeded; ++i) {
            result |= ((long)this.content[i] & 0xFFL) << i * 8;
        }
        return result;
    }

    public byte[] getRawData() {
        byte[] copy = new byte[this.content.length];
        System.arraycopy(this.content, 0, copy, 0, this.content.length);
        return copy;
    }

    public int getRawDataSize() {
        return this.content.length;
    }

    public int getStreamNumber() {
        return this.streamNumber;
    }

    public String getString() {
        String result = null;
        switch (this.getType()) {
            case 1: {
                result = "binary data";
                break;
            }
            case 2: {
                result = String.valueOf(this.getBoolean());
                break;
            }
            case 6: {
                result = this.getGuid() == null ? "Invalid GUID" : this.getGuid().toString();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                result = String.valueOf(this.getNumber());
                break;
            }
            case 0: {
                try {
                    result = new String(this.content, "UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.warning(e.getMessage());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Current type is not known.");
            }
        }
        return result;
    }

    public int getType() {
        return this.descriptorType;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public void setBinaryValue(byte[] data) throws IllegalArgumentException {
        this.containerType.assertConstraints(this.name, data, this.descriptorType, this.streamNumber, this.languageIndex);
        this.content = (byte[])data.clone();
        this.descriptorType = 1;
    }

    public void setBooleanValue(boolean value) {
        this.content = new byte[]{value ? (byte)1 : 0};
        this.descriptorType = 2;
    }

    public void setDWordValue(long value) {
        if (value < 0L || value > DWORD_MAXVALUE) {
            throw new IllegalArgumentException("value out of range (0-" + DWORD_MAXVALUE + ")");
        }
        this.content = Utils.getBytes(value, 4);
        this.descriptorType = 3;
    }

    public void setGUIDValue(GUID value) {
        this.containerType.assertConstraints(this.name, value.getBytes(), 6, this.streamNumber, this.languageIndex);
        this.content = value.getBytes();
        this.descriptorType = 6;
    }

    public void setLanguageIndex(int language) {
        this.containerType.assertConstraints(this.name, this.content, this.descriptorType, this.streamNumber, language);
        this.languageIndex = language;
    }

    public void setQWordValue(BigInteger value) throws IllegalArgumentException {
        if (value == null) {
            throw new NumberFormatException("null");
        }
        if (BigInteger.ZERO.compareTo(value) > 0) {
            throw new IllegalArgumentException("Only unsigned values allowed (no negative)");
        }
        if (QWORD_MAXVALUE.compareTo(value) < 0) {
            throw new IllegalArgumentException("Value exceeds QWORD (64 bit unsigned)");
        }
        this.content = new byte[8];
        byte[] valuesBytes = value.toByteArray();
        if (valuesBytes.length <= 8) {
            for (int i = valuesBytes.length - 1; i >= 0; --i) {
                this.content[valuesBytes.length - (i + 1)] = valuesBytes[i];
            }
        } else {
            Arrays.fill(this.content, (byte)-1);
        }
        this.descriptorType = 4;
    }

    public void setQWordValue(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value out of range (0-" + QWORD_MAXVALUE.toString() + ")");
        }
        this.content = Utils.getBytes(value, 8);
        this.descriptorType = 4;
    }

    public void setStreamNumber(int stream) {
        this.containerType.assertConstraints(this.name, this.content, this.descriptorType, stream, this.languageIndex);
        this.streamNumber = stream;
    }

    public void setString(String value) throws IllegalArgumentException {
        try {
            switch (this.getType()) {
                case 1: {
                    throw new IllegalArgumentException("Cannot interpret binary as string.");
                }
                case 2: {
                    this.setBooleanValue(Boolean.parseBoolean(value));
                    break;
                }
                case 3: {
                    this.setDWordValue(Long.parseLong(value));
                    break;
                }
                case 4: {
                    this.setQWordValue(new BigInteger(value, 10));
                    break;
                }
                case 5: {
                    this.setWordValue(Integer.parseInt(value));
                    break;
                }
                case 6: {
                    this.setGUIDValue(GUID.parseGUID(value));
                    break;
                }
                case 0: {
                    this.setStringValue(value);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Value cannot be parsed as Number or is out of range (\"" + value + "\")", nfe);
        }
    }

    public void setStringValue(String value) throws IllegalArgumentException {
        if (value == null) {
            this.content = new byte[0];
        } else {
            byte[] tmp = Utils.getBytes(value, AsfHeader.ASF_CHARSET);
            if (this.getContainerType().isWithinValueRange(tmp.length)) {
                this.content = tmp;
            } else if (TagOptionSingleton.getInstance().isTruncateTextWithoutErrors()) {
                int copyBytes = (int)this.getContainerType().getMaximumDataLength().longValue();
                this.content = new byte[copyBytes % 2 == 0 ? copyBytes : copyBytes - 1];
                System.arraycopy(tmp, 0, this.content, 0, this.content.length);
            } else {
                throw new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_DATA_IS_TOO_LARGE.getMsg(tmp.length, this.getContainerType().getMaximumDataLength(), this.getContainerType().getContainerGUID().getDescription()));
            }
        }
        this.descriptorType = 0;
    }

    public void setWordValue(int value) throws IllegalArgumentException {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException("value out of range (0-65535)");
        }
        this.content = Utils.getBytes(value, 2);
        this.descriptorType = 5;
    }

    public String toString() {
        return this.getName() + " : " + (new String[]{"String: ", "Binary: ", "Boolean: ", "DWORD: ", "QWORD:", "WORD:", "GUID:"})[this.descriptorType] + this.getString() + " (language: " + this.languageIndex + " / stream: " + this.streamNumber + ")";
    }

    public int writeInto(OutputStream out, ContainerType contType) throws IOException {
        byte[] binaryData;
        int size = this.getCurrentAsfSize(contType);
        if (this.descriptorType == 2) {
            binaryData = new byte[contType == ContainerType.EXTENDED_CONTENT ? 4 : 2];
            binaryData[0] = (byte)(this.getBoolean() ? 1 : 0);
        } else {
            binaryData = this.content;
        }
        if (contType != ContainerType.EXTENDED_CONTENT) {
            Utils.writeUINT16(this.getLanguageIndex(), out);
            Utils.writeUINT16(this.getStreamNumber(), out);
        }
        Utils.writeUINT16(this.getName().length() * 2 + 2, out);
        if (contType == ContainerType.EXTENDED_CONTENT) {
            out.write(Utils.getBytes(this.getName(), AsfHeader.ASF_CHARSET));
            out.write(AsfHeader.ZERO_TERM);
        }
        int type = this.getType();
        Utils.writeUINT16(type, out);
        int contentLen = binaryData.length;
        if (0 == type) {
            contentLen += 2;
        }
        if (contType == ContainerType.EXTENDED_CONTENT) {
            Utils.writeUINT16(contentLen, out);
        } else {
            Utils.writeUINT32(contentLen, out);
        }
        if (contType != ContainerType.EXTENDED_CONTENT) {
            out.write(Utils.getBytes(this.getName(), AsfHeader.ASF_CHARSET));
            out.write(AsfHeader.ZERO_TERM);
        }
        out.write(binaryData);
        if (0 == type) {
            out.write(AsfHeader.ZERO_TERM);
        }
        return size;
    }
}

