/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.datatype.Pair;
import org.jaudiotagger.tag.datatype.TextEncodedStringNullTerminated;
import org.jaudiotagger.tag.datatype.TextEncodedStringSizeTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.utils.EqualsUtil;

public class PairedTextEncodedStringNullTerminated
extends AbstractDataType {
    public PairedTextEncodedStringNullTerminated(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
        this.value = new ValuePairs();
    }

    public PairedTextEncodedStringNullTerminated(TextEncodedStringSizeTerminated object) {
        super(object);
        this.value = new ValuePairs();
    }

    public PairedTextEncodedStringNullTerminated(PairedTextEncodedStringNullTerminated object) {
        super(object);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PairedTextEncodedStringNullTerminated)) {
            return false;
        }
        PairedTextEncodedStringNullTerminated that = (PairedTextEncodedStringNullTerminated)obj;
        return EqualsUtil.areEqual(this.value, that.value);
    }

    public int getSize() {
        return this.size;
    }

    public boolean canBeEncoded() {
        for (Pair entry : ((ValuePairs)this.value).mapping) {
            TextEncodedStringNullTerminated next = new TextEncodedStringNullTerminated(this.identifier, this.frameBody, entry.getValue());
            if (next.canBeEncoded()) continue;
            return false;
        }
        return true;
    }

    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        block5: {
            logger.finer("Reading PairTextEncodedStringNullTerminated from array from offset:" + offset);
            do {
                try {
                    TextEncodedStringNullTerminated key = new TextEncodedStringNullTerminated(this.identifier, this.frameBody);
                    key.readByteArray(arr, offset);
                    this.size += key.getSize();
                    offset += key.getSize();
                    if (key.getSize() != 0) {
                        TextEncodedStringNullTerminated result = new TextEncodedStringNullTerminated(this.identifier, this.frameBody);
                        result.readByteArray(arr, offset);
                        this.size += result.getSize();
                        offset += result.getSize();
                        if (result.getSize() != 0) {
                            ((ValuePairs)this.value).add((String)key.getValue(), (String)result.getValue());
                            continue;
                        }
                    }
                    break block5;
                }
                catch (InvalidDataTypeException idte) {
                    break block5;
                }
            } while (this.size != 0);
            logger.warning("No null terminated Strings found");
            throw new InvalidDataTypeException("No null terminated Strings found");
        }
        logger.finer("Read  PairTextEncodedStringNullTerminated:" + this.value + " size:" + this.size);
    }

    public byte[] writeByteArray() {
        logger.finer("Writing PairTextEncodedStringNullTerminated");
        int localSize = 0;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            for (Pair pair : ((ValuePairs)this.value).mapping) {
                TextEncodedStringNullTerminated next = new TextEncodedStringNullTerminated(this.identifier, this.frameBody, pair.getKey());
                buffer.write(next.writeByteArray());
                localSize += next.getSize();
                next = new TextEncodedStringNullTerminated(this.identifier, this.frameBody, pair.getValue());
                buffer.write(next.writeByteArray());
                localSize += next.getSize();
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "IOException in MultipleTextEncodedStringNullTerminated when writing byte array", ioe);
            throw new RuntimeException(ioe);
        }
        this.size = localSize;
        logger.finer("Written PairTextEncodedStringNullTerminated");
        return buffer.toByteArray();
    }

    public ValuePairs getValue() {
        return (ValuePairs)this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValuePairs {
        private List<Pair> mapping = new ArrayList<Pair>();

        public void add(String key, String value) {
            this.mapping.add(new Pair(key, value));
        }

        public List<Pair> getMapping() {
            return this.mapping;
        }

        public int getNumberOfValues() {
            return this.mapping.size();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (Pair next : this.mapping) {
                sb.append(next.getKey() + ':' + next.getValue() + ',');
            }
            return sb.toString();
        }

        public int getNumberOfPairs() {
            return this.mapping.size();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ValuePairs)) {
                return false;
            }
            ValuePairs that = (ValuePairs)obj;
            return EqualsUtil.areEqual(this.getNumberOfValues(), that.getNumberOfValues());
        }
    }
}

