/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4.field;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.Mp4TagField;
import org.jaudiotagger.tag.mp4.atom.Mp4DataBox;
import org.jaudiotagger.tag.mp4.atom.Mp4MeanBox;
import org.jaudiotagger.tag.mp4.atom.Mp4NameBox;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public class Mp4TagReverseDnsField
extends Mp4TagField
implements TagTextField {
    public static final String IDENTIFIER = "----";
    protected int dataSize;
    private String issuer;
    private String descriptor;
    protected String content;

    public Mp4TagReverseDnsField(Mp4BoxHeader parentHeader, ByteBuffer data) throws UnsupportedEncodingException {
        super(parentHeader, data);
    }

    public Mp4TagReverseDnsField(Mp4FieldKey id, String content) {
        super(id.getFieldName());
        this.issuer = id.getIssuer();
        this.descriptor = id.getIdentifier();
        this.content = content;
    }

    public Mp4TagReverseDnsField(String fieldName, String issuer, String identifier, String content) {
        super(fieldName);
        this.issuer = issuer;
        this.descriptor = identifier;
        this.content = content;
    }

    public Mp4FieldType getFieldType() {
        return Mp4FieldType.TEXT;
    }

    protected void build(ByteBuffer data) throws UnsupportedEncodingException {
        Mp4BoxHeader meanBoxHeader = new Mp4BoxHeader(data);
        Mp4MeanBox meanBox = new Mp4MeanBox(meanBoxHeader, data);
        this.setIssuer(meanBox.getIssuer());
        data.position(data.position() + meanBoxHeader.getDataLength());
        Mp4BoxHeader nameBoxHeader = new Mp4BoxHeader(data);
        Mp4NameBox nameBox = new Mp4NameBox(nameBoxHeader, data);
        this.setDescriptor(nameBox.getName());
        data.position(data.position() + nameBoxHeader.getDataLength());
        if (this.parentHeader.getDataLength() == meanBoxHeader.getLength() + nameBoxHeader.getLength()) {
            this.id = "----:" + this.issuer + ":" + this.descriptor;
            this.setContent("");
            logger.warning(ErrorMessage.MP4_REVERSE_DNS_FIELD_HAS_NO_DATA.getMsg(this.id));
        } else {
            Mp4BoxHeader dataBoxHeader = new Mp4BoxHeader(data);
            Mp4DataBox dataBox = new Mp4DataBox(dataBoxHeader, data);
            this.setContent(dataBox.getContent());
            data.position(data.position() + dataBoxHeader.getDataLength());
            this.id = "----:" + this.issuer + ":" + this.descriptor;
        }
    }

    public void copyContent(TagField field) {
        if (field instanceof Mp4TagReverseDnsField) {
            this.issuer = ((Mp4TagReverseDnsField)field).getIssuer();
            this.descriptor = ((Mp4TagReverseDnsField)field).getDescriptor();
            this.content = ((Mp4TagReverseDnsField)field).getContent();
        }
    }

    public String getContent() {
        return this.content;
    }

    protected byte[] getDataBytes() throws UnsupportedEncodingException {
        return this.content.getBytes(this.getEncoding());
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public byte[] getRawContent() throws UnsupportedEncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] issuerRawData = this.issuer.getBytes(this.getEncoding());
            baos.write(Utils.getSizeBEInt32(12 + issuerRawData.length));
            baos.write(Utils.getDefaultBytes("mean", "ISO-8859-1"));
            baos.write(new byte[]{0, 0, 0, 0});
            baos.write(issuerRawData);
            byte[] nameRawData = this.descriptor.getBytes(this.getEncoding());
            baos.write(Utils.getSizeBEInt32(12 + nameRawData.length));
            baos.write(Utils.getDefaultBytes("name", "ISO-8859-1"));
            baos.write(new byte[]{0, 0, 0, 0});
            baos.write(nameRawData);
            if (this.content.length() > 0) {
                baos.write(this.getRawContentDataOnly());
            }
            ByteArrayOutputStream outerbaos = new ByteArrayOutputStream();
            outerbaos.write(Utils.getSizeBEInt32(8 + baos.size()));
            outerbaos.write(Utils.getDefaultBytes(IDENTIFIER, "ISO-8859-1"));
            outerbaos.write(baos.toByteArray());
            return outerbaos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public byte[] getRawContentDataOnly() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] dataRawData = this.content.getBytes(this.getEncoding());
            baos.write(Utils.getSizeBEInt32(16 + dataRawData.length));
            baos.write(Utils.getDefaultBytes("data", "ISO-8859-1"));
            baos.write(new byte[]{0});
            baos.write(new byte[]{0, 0, (byte)this.getFieldType().getFileClassId()});
            baos.write(new byte[]{0, 0, 0, 0});
            baos.write(dataRawData);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isEmpty() {
        return this.content.trim().equals("");
    }

    public void setContent(String s) {
        this.content = s;
    }

    public void setEncoding(String s) {
    }

    public String toString() {
        return this.content;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }
}

