/*
 * Decompiled with CFR 0.152.
 */
package xmlwise;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import xmlwise.XmlParseException;
import xmlwise.Xmlwise;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlElementAttributes
extends HashMap<String, String> {
    XmlElementAttributes() {
    }

    public XmlElementAttributes(Element element) {
        super(element.getAttributes().getLength());
        NamedNodeMap map = element.getAttributes();
        int attributesLength = map.getLength();
        for (int i = 0; i < attributesLength; ++i) {
            this.put(map.item(i).getNodeName(), map.item(i).getNodeValue());
        }
    }

    public int getInt(String attribute) throws XmlParseException {
        String value = (String)this.get(attribute);
        if (value == null) {
            throw new XmlParseException("Could not find attribute " + attribute);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new XmlParseException("Failed to parse int attribute " + attribute, e);
        }
    }

    public double getDouble(String attribute) throws XmlParseException {
        String value = (String)this.get(attribute);
        if (value == null) {
            throw new XmlParseException("Could not find attribute " + attribute);
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new XmlParseException("Failed to parse double attribute " + attribute, e);
        }
    }

    public boolean getBoolean(String attribute) throws XmlParseException {
        String value = (String)this.get(attribute);
        if (value == null) {
            throw new XmlParseException("Could not find attribute " + attribute);
        }
        if ("true".equals(value = value.toLowerCase()) || "yes".equals(value) || "y".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "n".equals(value)) {
            return false;
        }
        throw new XmlParseException("Attribute " + attribute + " did not have boolean value (was: " + value + ')');
    }

    public String toXml() {
        StringBuilder builder = new StringBuilder(10 * this.size());
        for (Map.Entry entry : this.entrySet()) {
            builder.append(' ').append((String)entry.getKey()).append("=").append("'");
            builder.append(Xmlwise.escapeXML((String)entry.getValue())).append("'");
        }
        return builder.toString();
    }
}

