﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudfront/model/ListConnectionFunctions2020_05_31Request.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/core/utils/xml/XmlSerializer.h>

#include <utility>

using namespace Aws::CloudFront::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils;

Aws::String ListConnectionFunctions2020_05_31Request::SerializePayload() const {
  XmlDocument payloadDoc = XmlDocument::CreateWithRootNode("ListConnectionFunctionsRequest");

  XmlNode parentNode = payloadDoc.GetRootElement();
  parentNode.SetAttributeValue("xmlns", "http://cloudfront.amazonaws.com/doc/2020-05-31/");

  Aws::StringStream ss;
  if (m_markerHasBeenSet) {
    XmlNode markerNode = parentNode.CreateChildElement("Marker");
    markerNode.SetText(m_marker);
  }

  if (m_maxItemsHasBeenSet) {
    XmlNode maxItemsNode = parentNode.CreateChildElement("MaxItems");
    ss << m_maxItems;
    maxItemsNode.SetText(ss.str());
    ss.str("");
  }

  if (m_stageHasBeenSet) {
    XmlNode stageNode = parentNode.CreateChildElement("Stage");
    stageNode.SetText(FunctionStageMapper::GetNameForFunctionStage(m_stage));
  }

  return payloadDoc.ConvertToString();
}
